/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.handler;

import com.infinityraider.infinitylib.InfinityLib;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConfigurationHandler {
    private static final ConfigurationHandler INSTANCE = new ConfigurationHandler();
    private Configuration config;
    public boolean debug;

    private ConfigurationHandler() {
    }

    public static ConfigurationHandler getInstance() {
        return INSTANCE;
    }

    public void init(FMLPreInitializationEvent event) {
        if (this.config == null) {
            this.config = new Configuration(event.getSuggestedConfigurationFile());
        }
        this.loadConfiguration();
        if (this.config.hasChanged()) {
            this.config.save();
        }
        InfinityLib.instance.getLogger().debug("Configuration Loaded", new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void initClientConfigs(FMLPreInitializationEvent event) {
        if (this.config == null) {
            this.config = new Configuration(event.getSuggestedConfigurationFile());
        }
        this.loadClientConfiguration(event);
        if (this.config.hasChanged()) {
            this.config.save();
        }
        InfinityLib.instance.getLogger().debug("Client configuration Loaded", new Object[0]);
    }

    private void loadConfiguration() {
        this.debug = this.config.getBoolean("debug", Categories.DEBUG.getName(), false, "Set to true if you wish to enable debug mode");
    }

    @SideOnly(value=Side.CLIENT)
    private void loadClientConfiguration(FMLPreInitializationEvent event) {
    }

    public static enum Categories {
        DEBUG("debug");

        private final String name;

        private Categories(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

