/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.crafttweaker;

import com.google.common.collect.ImmutableList;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import reborncore.api.praescriptum.ingredients.output.ItemStackOutputIngredient;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.api.praescriptum.recipes.RecipeHandler;
import reborncore.common.util.ItemUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techreborn.api.recipe.Recipes;
import techreborn.compatmod.crafttweaker.CTPraescriptum;
import techreborn.compatmod.crafttweaker.ZenDocumentation;

@ZenClass(value="mods.techreborn.wireMill")
public class CTWireMill
extends CTPraescriptum {
    @ZenMethod
    @ZenDocumentation(value="IItemStack output, IIngredient ingredient, int tickTime, int energyCostPerTick")
    public static void addRecipe(IItemStack output, IIngredient ingredient, int operationDuration, int energyCostPerTick) {
        ItemStackInputIngredient input = ingredient instanceof IItemStack ? ItemStackInputIngredient.of((ItemStack)ItemUtils.copyWithSize((ItemStack)CraftTweakerMC.getItemStack((IIngredient)ingredient), (int)ingredient.getAmount())) : OreDictionaryInputIngredient.of((String)((IOreDictEntry)ingredient).getName(), (int)ingredient.getAmount());
        Recipe recipe = CTWireMill.getRecipeHandler().createRecipe().withInput((List)ImmutableList.of((Object)input)).withOutput(CraftTweakerMC.getItemStack((IItemStack)output)).withEnergyCostPerTick(energyCostPerTick).withOperationDuration(operationDuration);
        CTWireMill.add(recipe);
    }

    @ZenMethod
    @ZenDocumentation(value="IItemStack output")
    public static void removeRecipe(IItemStack output) {
        ItemStack outStack = CraftTweakerMC.getItemStack((IItemStack)output);
        Optional maybeRecipe = CTWireMill.getRecipeHandler().getRecipeByOutput(ImmutableList.of((Object)ItemStackOutputIngredient.of((ItemStack)outStack)));
        maybeRecipe.ifPresent(recipe -> CTWireMill.getRecipeHandler().removeRecipe(recipe));
    }

    @ZenMethod
    @ZenDocumentation(value="IItemStack ingredient")
    public static void removeInputRecipe(IItemStack ingredient) {
        ItemStack input = CraftTweakerMC.getItemStack((IItemStack)ingredient);
        Optional maybeRecipe = CTWireMill.getRecipeHandler().findRecipe(ImmutableList.of((Object)input), ImmutableList.of());
        maybeRecipe.ifPresent(recipe -> CTWireMill.getRecipeHandler().removeRecipe(recipe));
    }

    @ZenMethod
    public static void removeAll() {
        CTWireMill.removeAll(CTWireMill.getRecipeHandler());
    }

    public static RecipeHandler getRecipeHandler() {
        return Recipes.wireMill;
    }
}

