/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.api.unlockable;

import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.api.event.CacheInvalidatedEvent;
import codersafterdark.reskillable.api.requirement.Requirement;
import codersafterdark.reskillable.api.toast.ToastHelper;
import codersafterdark.reskillable.api.unlockable.Unlockable;
import codersafterdark.reskillable.base.LevelLockHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AutoUnlocker {
    private static Set<Unlockable> unlockables = new HashSet<Unlockable>();
    private static boolean hasUncacheable;
    private static boolean hasBeenSet;

    public static void setUnlockables() {
        hasBeenSet = true;
        if (unlockables.isEmpty()) {
            Collection entries = ReskillableRegistries.UNLOCKABLES.getValuesCollection();
            for (Unlockable u : entries) {
                if (!u.isEnabled() || u.getCost() != 0) continue;
                AutoUnlocker.addUnlockable(u);
            }
        } else {
            AutoUnlocker.recheckUnlockables();
        }
    }

    private static void addUnlockable(Unlockable u) {
        unlockables.add(u);
        if (!hasUncacheable) {
            for (Requirement requirement : u.getRequirements().getRequirements()) {
                if (requirement.isCacheable()) continue;
                hasUncacheable = true;
                break;
            }
        }
    }

    public static void recheckUnlockables() {
        if (!hasBeenSet) {
            return;
        }
        Collection entries = ReskillableRegistries.UNLOCKABLES.getValuesCollection();
        for (Unlockable u : entries) {
            if (u.isEnabled() && u.getCost() == 0) {
                AutoUnlocker.addUnlockable(u);
                continue;
            }
            unlockables.remove(u);
        }
    }

    public static void recheck(EntityPlayer player) {
        PlayerData data = PlayerDataHandler.get(player);
        if (data == null) {
            return;
        }
        boolean anyUnlocked = false;
        for (Unlockable u : unlockables) {
            RequirementHolder holder;
            PlayerSkillInfo skillInfo = data.getSkillInfo(u.getParentSkill());
            if (skillInfo.isUnlocked(u) || !(holder = u.getRequirements()).equals(LevelLockHandler.EMPTY_LOCK) && !data.matchStats(holder)) continue;
            skillInfo.unlock(u, player);
            if (player instanceof EntityPlayerMP) {
                ToastHelper.sendUnlockableToast((EntityPlayerMP)player, u);
            }
            anyUnlocked = true;
        }
        if (anyUnlocked) {
            data.saveAndSync();
        }
    }

    @SubscribeEvent
    public static void onCacheInvalidated(CacheInvalidatedEvent event) {
        AutoUnlocker.recheck(event.getPlayer());
    }

    @SubscribeEvent
    public static void onEntityLiving(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLiving;
        if (hasUncacheable && (entityLiving = event.getEntityLiving()) instanceof EntityPlayer && !entityLiving.field_70170_p.field_72995_K && entityLiving.field_70173_aa % 100 == 0) {
            AutoUnlocker.recheck((EntityPlayer)entityLiving);
        }
    }
}

