/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.grue;

import com.shinoow.grue.common.CommonProxy;
import com.shinoow.grue.common.entity.EntityGrue;
import com.shinoow.grue.common.entity.cap.GrueTimerCapability;
import com.shinoow.grue.common.entity.cap.GrueTimerCapabilityStorage;
import com.shinoow.grue.common.entity.cap.IGrueTimerCapability;
import com.shinoow.grue.common.handlers.GrueEventHandler;
import com.shinoow.grue.common.integrations.gamestages.GameStagesHandler;
import com.shinoow.grue.common.network.PacketDispatcher;
import com.shinoow.grue.common.util.DimensionData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="grue", name="Grue", version="1.8.0", dependencies="required-after:forge@[14.23.5.2768,);required-after:darknesslib@[1.1.0,)", acceptedMinecraftVersions="[1.12.2]", guiFactory="com.shinoow.grue.client.config.GrueGuiFactory", updateJSON="https://raw.githubusercontent.com/Shinoow/Grue/master/version.json", useMetadata=false, certificateFingerprint="220f10d3a93b3ff5fbaa7434cc629d863d6751b9")
public class Grue {
    public static final String version = "1.8.0";
    public static final String modid = "grue";
    public static final String name = "Grue";
    @Mod.Metadata(value="grue")
    public static ModMetadata metadata;
    @Mod.Instance(value="grue")
    public static Grue instance;
    @SidedProxy(clientSide="com.shinoow.grue.client.ClientProxy", serverSide="com.shinoow.grue.common.CommonProxy")
    public static CommonProxy proxy;
    public static Configuration cfg;
    public static boolean useWhitelist;
    public static boolean wimpMode;
    public static boolean displayWarningText;
    public static boolean useBlacklist;
    public static boolean warningChat;
    public static boolean useGracePeriod;
    public static boolean spawnAtPlayer;
    public static boolean useBiomeBlacklist;
    public static boolean singleGrue;
    public static boolean dynLightPausesTimer;
    public static float wimpModeDamage;
    public static int spawnTimer;
    public static int flyHeight;
    public static int gracePeriod;
    public static int minLight;
    public static int maxLight;
    public static int[] dimWhitelist;
    public static String[] biomeWhitelist;
    public static String[] spawn_stages;
    public static String[] nospawn_stages;
    public static double[] moonPhases;
    private static DimensionData config_default;
    public static final List<Integer> whitelist_override;
    public static final List<Biome> biome_whitelist;
    public static final List<Biome> biome_whitelist_override;
    public static Map<Integer, DimensionData> dimension_configs;
    public static final DamageSource grueDamage;
    public static final DamageSource wimpGrueDamage;
    public static SoundEvent grue_spawn;
    public static SoundEvent grue_whisper;
    public static SoundEvent grue_death;
    public static final ResourceLocation grue_loot_table;
    public static Logger LOGGER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        metadata = event.getModMetadata();
        Grue.metadata.description = Grue.metadata.description + "\n\n\u00a76Supporters: " + this.getSupporterList() + "\u00a7r";
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)new GrueEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        cfg = new Configuration(event.getSuggestedConfigurationFile());
        Grue.syncConfig();
        config_default = new ConfigDimData();
        grue_spawn = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "grue.spawn")).setRegistryName(new ResourceLocation(modid, "grue.spawn"));
        grue_whisper = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "grue.whisper")).setRegistryName(new ResourceLocation(modid, "grue.whisper"));
        grue_death = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "grue.death")).setRegistryName(new ResourceLocation(modid, "grue.death"));
        CapabilityManager.INSTANCE.register(IGrueTimerCapability.class, GrueTimerCapabilityStorage.instance, GrueTimerCapability::new);
        Grue.registerEntityWithEgg(EntityGrue.class, "EntityGrue", 1, 80, 3, true, 0, 0);
        PacketDispatcher.registerPackets();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        proxy.init();
        if (Loader.isModLoaded((String)"gamestages")) {
            GameStagesHandler.init();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        Arrays.stream(biomeWhitelist).map(b -> new ResourceLocation(b)).forEach(b -> Grue.addBiomeToList(b));
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LOGGER.log(Level.WARN, "Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        ArrayList<String> senders = new ArrayList<String>();
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            if (imcMessage.key.equals("registerDimensionWhitelistOverride")) {
                int id = Integer.valueOf(imcMessage.getStringValue());
                whitelist_override.add(id);
                LOGGER.log(Level.INFO, "Received Dimension Whitelist Override for dimension {} from mod {}", (Object)imcMessage.getStringValue(), (Object)imcMessage.getSender());
                if (senders.contains(imcMessage.getSender())) continue;
                senders.add(imcMessage.getSender());
                continue;
            }
            if (imcMessage.key.equals("registerBiomeWhitelistOverride")) {
                ResourceLocation id = new ResourceLocation(imcMessage.getStringValue());
                if (ForgeRegistries.BIOMES.containsKey(id)) {
                    biome_whitelist_override.add((Biome)ForgeRegistries.BIOMES.getValue(id));
                    LOGGER.log(Level.INFO, "Received Biome Whitelist Override for dimension {} from mod {}", (Object)imcMessage.getStringValue(), (Object)imcMessage.getSender());
                }
                if (senders.contains(imcMessage.getSender())) continue;
                senders.add(imcMessage.getSender());
                continue;
            }
            LOGGER.log(Level.WARN, "Received an IMC Message with unknown key ({}) from mod {}!", (Object)imcMessage.key, (Object)imcMessage.getSender());
        }
        if (!senders.isEmpty()) {
            LOGGER.log(Level.INFO, "Recieved messages from the following mods: {}", senders);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(modid)) {
            Grue.syncConfig();
            biome_whitelist.clear();
            Arrays.stream(biomeWhitelist).map(b -> new ResourceLocation(b)).forEach(b -> Grue.addBiomeToList(b));
        }
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)grue_spawn);
        event.getRegistry().register((IForgeRegistryEntry)grue_whisper);
        event.getRegistry().register((IForgeRegistryEntry)grue_death);
    }

    private static void syncConfig() {
        spawnTimer = cfg.getInt("Grue spawn timer", "general", 10, 1, 60, "Change the value to increase the time it takes before a Grue spawns.\n");
        wimpMode = cfg.get("general", "Wimp mode", false, "Toggles wimp-mode, which reduces the Grue's damage output to 3 hearts (a 6.505213034913026604750013415713e-19th of the default).").getBoolean();
        useWhitelist = cfg.get("general", "Grue dimension whitelist", false, "Toggles the Grue dimension whitelist (used to force the Grues to only spawn in certain dimensions).").getBoolean();
        dimWhitelist = cfg.get("general", "Whitelist", new int[]{0}, "Add dimension IDs to this list if you want Grues to spawn here.\n" + TextFormatting.RED + "[Only used if Grue dimension whitelist is enabled]" + TextFormatting.RESET).getIntList();
        displayWarningText = cfg.get("general", "Display Warning Text", true, "Toggles whether or not to display the warning text when in dark areas. [CLIENT ONLY]").getBoolean();
        flyHeight = cfg.getInt("Flying Height", "general", 2, 0, 3, "The height above ground at which a Grue will still spawn (the spawning waits if you're flying above the height). If set to 0, it will act as if you're not flying\n");
        useBlacklist = cfg.get("general", "Use Blacklist", false, "Toggles whether or not to use the dimension whitelist as a blacklist instead.").getBoolean();
        warningChat = cfg.get("general", "Warning text in chat", false, "Toggles whether or not to display the warning text in the chat rather than above the hotbar.").getBoolean();
        useGracePeriod = cfg.get("general", "Dimensional Grace Period", false, "Toggles whether or not to have a grace period after changing dimension before the Grue timer continues to count down.").getBoolean();
        gracePeriod = cfg.getInt("Grace Period Timer", "general", 5, 1, 30, "Sets the amount of seconds before the Grue timer resumes after changing dimension.\n" + TextFormatting.RED + "[Only used if Grue grace period is enabled]" + TextFormatting.RESET);
        spawnAtPlayer = cfg.get("general", "Grues Spawn At Players", false, "Toggles whether or not the Grue should spawn at the player's location, rather than where the spawn sound was played.").getBoolean();
        biomeWhitelist = cfg.get("general", "Biome Whitelist", new String[0], "Add biome IDs to this list if you want Grues to spawn here. The list won't be used if it's empty.\nFormat: modid:name").getStringList();
        useBiomeBlacklist = cfg.get("general", "Use Biome Blacklist", false, "Toggles whether or not to use the biome whitelist as a blacklist instead.").getBoolean();
        moonPhases = cfg.get("general", "Moon Phase Spawn List", new double[0], "If any numbers representing moon phases are added, the Grue will only spawn durning the night at those moon phases. A moon phase is represented as a number between 1.0 and 0.0, in steps of 0.25 (eg. full moon is 1.0, new moon is 0.0, half is 0.5). Only applicable to dimensions with a day-night cycle!").getDoubleList();
        singleGrue = cfg.get("general", "One Grue At a Time", false, "Toggles whether or not the Grue timer pauses when a Grue is within 10 blocks of the player, rather than continuing to count down (even after one has spawned).").getBoolean();
        wimpModeDamage = cfg.getFloat("Wimp Mode Damage", "general", 6.0f, 2.0f, 100.0f, "Sets the amount of damage (in half-hearts) the Grue deals when Wimp Mode is enabled.");
        minLight = cfg.getInt("Minimum Spawn Light Level", "general", 0, 0, 15, "Minimum light level at which the Grue can spawn.");
        maxLight = cfg.getInt("Maximum Spawn Light Level", "general", 1, 0, 15, "Maximum light level at which the Grue can spawn");
        String[] data = cfg.get("general", "Dimension-specific Configuration", new String[0], "Values added to this list will allow you to define dimension-specific configurations that override any of the corresponding global ones defined in the other options. \nFormat: dim_id:spawn_timer:use_grace_period:grace_period:wimp_mode:wimp_mode_damage:moon_phases:spawn_at_player:single_grue:min_light:max_light\nEvery value except dim_id and moon_phases can be substituted with def, which'll set the value to whatever the global config uses. moon_phases can be left blank if you don't wish to set it\nExample: '0:60:true:30:true:20:1.0,0.0:def:true:0:2'").getStringList();
        dynLightPausesTimer = cfg.get("general", "Dynamic Light Pauses Timer", false, "Toggles whether or not Dynamic Light pauses the timer, rather than adding to the light level. Pausing is what the old behavior did.").getBoolean();
        spawn_stages = cfg.get("general", "Spawning Stages", new String[0], "If Game Stages is installed, this list can be used to specify stages where the Grue spawns. Format is stage:priority, where stage is the stage name and the priority is an integer that determines if this takes effect over the non-spawning stages (higher number = higher priority).").getStringList();
        nospawn_stages = cfg.get("general", "Non-spawning Stages", new String[0], "If Game Stages is installed, this list can be used to specify stages where the Grue doesn't spawn. Format is stage:priority, where stage is the stage name and the priority is an integer that determines if this takes effect over the spawning stages (higher number = higher priority).").getStringList();
        dimension_configs = Arrays.stream(data).map(s -> s.trim().split(":")).collect(Collectors.toMap(s -> Integer.parseInt(s[0]), s -> new DimensionData((String)s)));
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    private static void addBiomeToList(ResourceLocation res) {
        if (ForgeRegistries.BIOMES.containsKey(res)) {
            biome_whitelist.add((Biome)ForgeRegistries.BIOMES.getValue(res));
        } else {
            LOGGER.log(Level.ERROR, "{} is not a valid Biome!", (Object)res);
        }
    }

    public static DimensionData getDimensionConfig(int id) {
        return dimension_configs.getOrDefault(id, config_default);
    }

    private static void registerEntityWithEgg(Class<? extends Entity> entity, String name, int modid, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int primaryColor, int secondaryColor) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(modid, name.toLowerCase(Locale.ENGLISH)), entity, (String)("grue." + name), (int)modid, (Object)instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)primaryColor, (int)secondaryColor);
    }

    private String getSupporterList() {
        String names = "";
        try {
            BufferedReader nameFile = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/Shinoow/AbyssalCraft/master/supporters.txt").openStream()));
            names = nameFile.readLine();
            nameFile.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.ERROR, "Failed to fetch supporter list, using local version!");
            names = "Gentlemangamer2015";
        }
        return names;
    }

    static {
        instance = new Grue();
        whitelist_override = new ArrayList<Integer>();
        biome_whitelist = new ArrayList<Biome>();
        biome_whitelist_override = new ArrayList<Biome>();
        dimension_configs = new HashMap<Integer, DimensionData>();
        grueDamage = new DamageSource(modid).func_76348_h().func_151518_m();
        wimpGrueDamage = new DamageSource("wimpgrue");
        grue_loot_table = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(modid, "entities/grue"));
        LOGGER = LogManager.getLogger((String)name);
    }

    private class ConfigDimData
    extends DimensionData {
        private ConfigDimData() {
        }

        @Override
        public int getMinLight() {
            return minLight;
        }

        @Override
        public int getMaxLight() {
            return maxLight;
        }

        @Override
        public int getSpawnTimer() {
            return spawnTimer;
        }

        @Override
        public int getGracePeriod() {
            return gracePeriod;
        }

        @Override
        public float getWimpDamage() {
            return wimpModeDamage;
        }

        @Override
        public boolean isWimpMode() {
            return wimpMode;
        }

        @Override
        public boolean isSingleGrue() {
            return singleGrue;
        }

        @Override
        public boolean shouldUseGracePeriod() {
            return useGracePeriod;
        }

        @Override
        public boolean shouldSpawnAtPlayer() {
            return spawnAtPlayer;
        }

        @Override
        public double[] getMoonPhases() {
            return moonPhases;
        }
    }
}

