/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block;

import it.zerono.mods.zerocore.lib.init.IGameObject;
import it.zerono.mods.zerocore.util.ItemHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class ModBlock
extends Block
implements IGameObject {
    private final String _oreDictionaryName;

    @Nonnull
    public ItemStack createItemStack() {
        return ItemHelper.stackFrom(this, 1, 0);
    }

    @Nonnull
    public ItemStack createItemStack(int amount) {
        return ItemHelper.stackFrom(this, amount, 0);
    }

    @Nonnull
    public ItemStack createItemStack(int amount, int meta) {
        return ItemHelper.stackFrom(this, amount, meta);
    }

    @Nullable
    public String getOreDictionaryName() {
        return this._oreDictionaryName;
    }

    @Override
    public void onRegisterItemBlocks(@Nonnull IForgeRegistry<Item> registry) {
        registry.register(new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    @Override
    public void onRegisterOreDictionaryEntries() {
        String name = this.getOreDictionaryName();
        if (!Strings.isNullOrEmpty((String)name)) {
            OreDictionary.registerOre((String)name, (Block)this);
        }
    }

    @Override
    public void onRegisterRecipes(@Nonnull IForgeRegistry<IRecipe> registry) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRegisterModels() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected ModBlock(@Nonnull String blockName, @Nonnull Material material, @Nullable String oreDictionaryName) {
        super(material);
        this._oreDictionaryName = oreDictionaryName;
        this.setRegistryName(blockName);
        this.func_149663_c(this.getRegistryName().toString());
        this.func_180632_j(this.buildDefaultState(this.field_176227_L.func_177621_b()));
    }

    protected ModBlock(@Nonnull String blockName, @Nonnull Material material) {
        this(blockName, material, null);
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        this.buildBlockState(builder);
        return builder.build();
    }

    protected void buildBlockState(@Nonnull BlockStateContainer.Builder builder) {
    }

    @Nonnull
    protected IBlockState buildDefaultState(@Nonnull IBlockState state) {
        return state;
    }
}

