/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.davincisvessels.common.entity;

import com.elytradev.davincisvessels.DavincisVesselsMod;
import com.elytradev.davincisvessels.client.control.ShipControllerClient;
import com.elytradev.davincisvessels.common.api.tileentity.ITileEngineModifier;
import com.elytradev.davincisvessels.common.control.ShipControllerCommon;
import com.elytradev.davincisvessels.common.entity.EntityParachute;
import com.elytradev.davincisvessels.common.entity.EntitySeat;
import com.elytradev.davincisvessels.common.entity.ShipAssemblyInteractor;
import com.elytradev.davincisvessels.common.entity.ShipCapabilities;
import com.elytradev.davincisvessels.common.entity.ShipHandlerClient;
import com.elytradev.davincisvessels.common.entity.ShipHandlerServer;
import com.elytradev.davincisvessels.common.object.DavincisVesselsObjects;
import com.elytradev.davincisvessels.common.tileentity.TileHelm;
import com.elytradev.movingworld.common.chunk.LocatedBlock;
import com.elytradev.movingworld.common.chunk.MovingWorldAssemblyInteractor;
import com.elytradev.movingworld.common.chunk.assembly.AssembleResult;
import com.elytradev.movingworld.common.chunk.assembly.ChunkDisassembler;
import com.elytradev.movingworld.common.entity.EntityMovingWorld;
import com.elytradev.movingworld.common.entity.MovingWorldCapabilities;
import com.elytradev.movingworld.common.entity.MovingWorldHandlerCommon;
import com.elytradev.movingworld.common.util.MathHelperMod;
import com.elytradev.movingworld.common.util.Vec3dMod;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class EntityShip
extends EntityMovingWorld {
    public static final DataParameter<Float> ENGINE_POWER = EntityDataManager.func_187226_a(EntityShip.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Byte> HAS_ENGINES = EntityDataManager.func_187226_a(EntityShip.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final DataParameter<Boolean> CAN_SUBMERGE = EntityDataManager.func_187226_a(EntityShip.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Byte> IS_SUBMERGED = EntityDataManager.func_187226_a(EntityShip.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final float BASE_FORWARD_SPEED = 0.005f;
    public static final float BASE_TURN_SPEED = 0.5f;
    public static final float BASE_LIFT_SPEED = 0.004f;
    public ShipCapabilities capabilities = new ShipCapabilities(this, true);
    private ShipControllerCommon controller;
    private MovingWorldHandlerCommon handler;
    private ShipAssemblyInteractor shipAssemblyInteractor;
    private int driftCooldown = 0;
    private boolean submerge;

    public EntityShip(World world) {
        super(world);
    }

    public void assembleResultEntity() {
        super.assembleResultEntity();
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p != null) {
            if (!this.field_70170_p.field_72995_K) {
                --this.driftCooldown;
                boolean hasEngines = false;
                if (this.capabilities.getEngines() != null) {
                    if (this.capabilities.getEngines().isEmpty()) {
                        hasEngines = false;
                    } else {
                        boolean bl = hasEngines = this.capabilities.getEnginePower() > 0.0f;
                    }
                }
                if (DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().enginesMandatory) {
                    this.func_184212_Q().func_187227_b(HAS_ENGINES, (Object)new Byte(hasEngines ? (byte)1 : 0));
                } else {
                    this.func_184212_Q().func_187227_b(HAS_ENGINES, (Object)new Byte(1));
                }
            }
            if (this.field_70170_p.field_72995_K && this.field_70180_af != null && !this.field_70180_af.func_187228_d() && this.field_70180_af.func_187223_a()) {
                this.submerge = this.field_70180_af.func_187225_a(IS_SUBMERGED) == new Byte(1);
            }
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((Block)DavincisVesselsObjects.blockMarkShip);
    }

    public boolean getSubmerge() {
        return !this.func_184212_Q().func_187228_d() ? (Byte)this.func_184212_Q().func_187225_a(IS_SUBMERGED) == 1 : false;
    }

    public void setSubmerge(boolean submerge) {
        this.submerge = submerge;
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(IS_SUBMERGED, (Object)(submerge ? new Byte(1) : new Byte(0)));
            if (this.getMobileChunk().marker != null && this.getMobileChunk().marker.tileEntity != null && this.getMobileChunk().marker.tileEntity instanceof TileHelm) {
                TileHelm helm = (TileHelm)this.getMobileChunk().marker.tileEntity;
                helm.submerge = submerge;
            }
        }
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity != null) {
            if (entity instanceof EntityMovingWorld) {
                EntityMovingWorld entityMovingWorld = (EntityMovingWorld)entity;
                return entityMovingWorld.func_174813_aQ();
            }
            if (entity instanceof EntitySeat || entity.func_184187_bx() instanceof EntitySeat || entity instanceof EntityLiving) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public MovingWorldHandlerCommon getHandler() {
        if (this.handler == null) {
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                this.handler = new ShipHandlerClient(this);
                this.handler.setMovingWorld((EntityMovingWorld)this);
            } else {
                this.handler = new ShipHandlerServer(this);
                this.handler.setMovingWorld((EntityMovingWorld)this);
            }
        }
        return this.handler;
    }

    public void initMovingWorld() {
        this.field_70180_af.func_187214_a(ENGINE_POWER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(HAS_ENGINES, (Object)0);
        this.field_70180_af.func_187214_a(CAN_SUBMERGE, (Object)false);
        this.field_70180_af.func_187214_a(IS_SUBMERGED, (Object)0);
    }

    @SideOnly(value=Side.CLIENT)
    public void initMovingWorldClient() {
        this.handler = new ShipHandlerClient(this);
        this.controller = new ShipControllerClient();
    }

    public void initMovingWorldCommon() {
        this.handler = new ShipHandlerServer(this);
        this.controller = new ShipControllerCommon();
    }

    public MovingWorldCapabilities getCapabilities() {
        return this.capabilities == null ? new ShipCapabilities(this, true) : this.capabilities;
    }

    public void setCapabilities(MovingWorldCapabilities capabilities) {
        if (capabilities != null && capabilities instanceof ShipCapabilities) {
            this.capabilities = (ShipCapabilities)capabilities;
        }
    }

    public boolean alignToAnchor() {
        ImmutablePair<LocatedBlock, LocatedBlock> closestRelation = this.capabilities.findClosestValidAnchor(DavincisVesselsMod.INSTANCE.getNetworkConfig().anchorRadius);
        if (!((LocatedBlock)closestRelation.getLeft()).equals(LocatedBlock.AIR) && !((LocatedBlock)closestRelation.getRight()).equals(LocatedBlock.AIR)) {
            Vec3dMod vecB;
            BlockPos chunkAnchor = ((LocatedBlock)closestRelation.getLeft()).blockPos;
            BlockPos worldAnchor = ((LocatedBlock)closestRelation.getRight()).blockPos;
            super.alignToGrid(true);
            float yaw = (float)Math.round(this.field_70177_z / 90.0f) * 90.0f;
            yaw = (float)Math.toRadians(yaw);
            float ox = -this.getMobileChunk().getCenterX();
            float oz = -this.getMobileChunk().getCenterZ();
            Vec3dMod vec = vecB = new Vec3dMod((double)((float)chunkAnchor.func_177958_n() + ox), 0.0, (double)((float)chunkAnchor.func_177952_p() + oz));
            vec = vec.rotateAroundY(yaw);
            BlockPos pos = new BlockPos(MathHelperMod.round_double((double)vec.field_72450_a), 0, MathHelperMod.round_double((double)vec.field_72449_c));
            this.func_70634_a(worldAnchor.func_177958_n() + -pos.func_177958_n(), worldAnchor.func_177956_o() + 2, worldAnchor.func_177952_p() + -pos.func_177952_p());
            super.alignToGrid(false);
            this.func_184232_k(this.func_184179_bs());
            return true;
        }
        return false;
    }

    public void alignToGrid(boolean doPosAdjustment) {
        if (!this.alignToAnchor()) {
            super.alignToGrid(true);
        }
    }

    public boolean isBraking() {
        return this.controller.getShipControl() == 3;
    }

    public MovingWorldAssemblyInteractor getNewAssemblyInteractor() {
        return new ShipAssemblyInteractor();
    }

    public void writeMovingWorldNBT(NBTTagCompound tag) {
        tag.func_74757_a("submerge", this.submerge);
    }

    public void readMovingWorldNBT(NBTTagCompound tag) {
        this.setSubmerge(tag.func_74767_n("submerge"));
    }

    public void writeMovingWorldSpawnData(ByteBuf data) {
    }

    public void handleControl(double horizontalVelocity) {
        this.capabilities.updateEngines();
        if (this.func_184179_bs() == null && this.prevRiddenByEntity != null) {
            if (DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().disassembleOnDismount) {
                this.alignToGrid(true);
                this.updatePassengerPosition(this.prevRiddenByEntity, this.riderDestination, 1);
                this.disassemble(false);
            } else if (!this.field_70170_p.field_72995_K && this.isFlying()) {
                this.driftCooldown = 120;
                EntityParachute parachute = new EntityParachute(this.field_70170_p, this, this.riderDestination);
                if (this.field_70170_p.func_72838_d((Entity)parachute)) {
                    this.prevRiddenByEntity.func_184220_m((Entity)parachute);
                    this.prevRiddenByEntity.func_70095_a(false);
                }
            }
            this.prevRiddenByEntity = null;
        }
        if (this.func_184179_bs() == null || !this.capabilities.canMove()) {
            if (this.isFlying()) {
                this.field_70181_x -= 8.00000037997961E-4;
            }
        } else {
            this.handlePlayerControl();
            this.prevRiddenByEntity = this.func_184179_bs();
        }
    }

    public void updatePassengerPosition(Entity passenger, BlockPos riderDestination, int flags) {
        super.updatePassengerPosition(passenger, riderDestination, flags);
        if (this.submerge && passenger != null && passenger instanceof EntityLivingBase && this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            Potion nightVision;
            Potion waterBreathing = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("water_breathing"));
            if (((EntityLivingBase)passenger).func_70660_b(waterBreathing) == null || ((EntityLivingBase)passenger).func_70660_b(waterBreathing).func_76459_b() <= 220) {
                ((EntityLivingBase)passenger).func_70690_d(new PotionEffect(waterBreathing, 240, 1));
            }
            if (((EntityLivingBase)passenger).func_70660_b(nightVision = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("night_vision"))) == null || ((EntityLivingBase)passenger).func_70660_b(nightVision).func_76459_b() <= 220) {
                ((EntityLivingBase)passenger).func_70690_d(new PotionEffect(nightVision, 240, 1));
            }
        }
    }

    protected String getHurtSound() {
        return "mob.irongolem.hit";
    }

    protected String getDeathSound() {
        return "mob.irongolem.death";
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(double horvel) {
        if (this.capabilities.getEngines() != null && !this.capabilities.getEngines().isEmpty()) {
            Vec3dMod vec = Vec3dMod.getOrigin();
            float yaw = (float)Math.toRadians(this.field_70177_z);
            for (ITileEngineModifier engine : this.capabilities.getEngines()) {
                if (engine.getPowerIncrement(this.capabilities) == 0.0f) continue;
                vec = vec.setX((double)((float)((TileEntity)engine).func_174877_v().func_177958_n() - this.getMobileChunk().getCenterX() + 0.5f));
                vec = vec.setY((double)((TileEntity)engine).func_174877_v().func_177956_o());
                vec = vec.setZ((double)((float)((TileEntity)engine).func_174877_v().func_177952_p() - this.getMobileChunk().getCenterZ() + 0.5f));
                vec = vec.rotateAroundY(yaw);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + vec.field_72450_a, this.field_70163_u + vec.field_72448_b + 1.0, this.field_70161_v + vec.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public int getBelowWater() {
        double d2;
        double d1;
        int belowWater;
        int b0 = 5;
        int blocksPerMeter = (int)((double)b0 * (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b));
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (belowWater = 0; belowWater < blocksPerMeter && EntityShip.isAABBInLiquidNotFall((World)this.field_70170_p, (AxisAlignedBB)(axisalignedbb = new AxisAlignedBB(this.func_174813_aQ().field_72340_a, d1 = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)belowWater / (double)blocksPerMeter, this.func_174813_aQ().field_72339_c, this.func_174813_aQ().field_72336_d, d2 = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)(belowWater + 1) / (double)blocksPerMeter, this.func_174813_aQ().field_72334_f))); ++belowWater) {
        }
        return belowWater;
    }

    public void handleServerUpdate(double horizontalVelocity) {
        double d2;
        double d1;
        int belowWater;
        boolean submergeMode = this.getSubmerge();
        int b0 = 5;
        int blocksPerMeter = (int)((double)b0 * (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b));
        float waterVolume = 0.0f;
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (belowWater = 0; belowWater < blocksPerMeter && EntityShip.isAABBInLiquidNotFall((World)this.field_70170_p, (AxisAlignedBB)(axisalignedbb = new AxisAlignedBB(this.func_174813_aQ().field_72340_a, d1 = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)belowWater / (double)blocksPerMeter, this.func_174813_aQ().field_72339_c, this.func_174813_aQ().field_72336_d, d2 = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)(belowWater + 1) / (double)blocksPerMeter, this.func_174813_aQ().field_72334_f))); ++belowWater) {
        }
        if (belowWater > 0 && this.layeredBlockVolumeCount != null) {
            int k = belowWater / b0;
            for (int y = 0; y <= k && y < this.layeredBlockVolumeCount.length; ++y) {
                if (y == k) {
                    waterVolume += (float)(this.layeredBlockVolumeCount[y] * (belowWater % b0)) * 1.0f / (float)b0;
                    continue;
                }
                waterVolume += (float)this.layeredBlockVolumeCount[y] * 1.0f;
            }
        }
        if (this.field_70122_E) {
            this.setFlying(false);
        }
        float gravity = 0.05f;
        if (waterVolume > 0.0f && !submergeMode) {
            this.setFlying(false);
            float buoyancyforce = 1.0f * waterVolume * gravity;
            float mass = this.getCapabilities().getMass();
            this.field_70181_x += (double)(buoyancyforce / mass);
        }
        if (DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().enableShipDownfall) {
            if (!this.isFlying() || submergeMode && belowWater <= this.getMobileChunk().maxY() * 5 / 3 * 2) {
                this.field_70181_x -= (double)gravity;
            }
        } else if (!this.capabilities.canFly() && !this.capabilities.canSubmerge()) {
            this.field_70181_x -= (double)gravity;
        }
        super.handleServerUpdate(horizontalVelocity);
    }

    public void handleServerUpdatePreRotation() {
        if (DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().shipControlType == 0) {
            double maxyawspeed;
            double deltayaw;
            double newYaw = this.field_70177_z;
            double dx = this.field_70169_q - this.field_70165_t;
            double dz = this.field_70166_s - this.field_70161_v;
            if (this.func_184179_bs() != null && !this.isBraking() && dx * dx + dz * dz > 0.01) {
                newYaw = 270.0 - Math.toDegrees(Math.atan2(dz, dx)) + (double)((float)this.frontDirection.func_176736_b() * 90.0f);
            }
            if ((deltayaw = MathHelper.func_76138_g((double)(newYaw - (double)this.field_70177_z))) > (maxyawspeed = 2.0)) {
                deltayaw = maxyawspeed;
            }
            if (deltayaw < -maxyawspeed) {
                deltayaw = -maxyawspeed;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + deltayaw);
        }
    }

    public boolean disassemble(boolean overwrite) {
        TileEntity te;
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        this.func_184232_k(this.func_184179_bs());
        ChunkDisassembler disassembler = this.getDisassembler();
        disassembler.overwrite = overwrite;
        if (!disassembler.canDisassemble(this.getNewAssemblyInteractor())) {
            if (this.prevRiddenByEntity instanceof EntityPlayer) {
                TextComponentString testMessage = new TextComponentString("Cannot disassemble ship here");
                ((EntityPlayer)this.prevRiddenByEntity).func_146105_b((ITextComponent)testMessage, true);
            }
            return false;
        }
        AssembleResult result = disassembler.doDisassemble(this.getNewAssemblyInteractor());
        if (result.getShipMarker() != null && (te = result.getShipMarker().tileEntity) instanceof TileHelm) {
            ((TileHelm)te).setAssembleResult(result);
            ((TileHelm)te).setInfo(this.getInfo());
        }
        return true;
    }

    private void handlePlayerControl() {
        if (this.func_184179_bs() instanceof EntityLivingBase && ((ShipCapabilities)this.getCapabilities()).canMove()) {
            double throttle = ((EntityLivingBase)this.func_184179_bs()).field_191988_bg;
            if (this.isFlying()) {
                throttle *= 0.5;
            }
            if (DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().shipControlType == 1) {
                Vec3dMod vec = new Vec3dMod(this.func_184179_bs().field_70159_w, 0.0, this.func_184179_bs().field_70179_y);
                vec.rotateAroundY((float)Math.toRadians(this.func_184179_bs().field_70177_z));
                double steer = ((EntityLivingBase)this.func_184179_bs()).field_70702_br;
                this.motionYaw = (float)((double)this.motionYaw + steer * 0.5 * (double)this.capabilities.getRotationMult() * (double)DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().turnSpeed);
                float yaw = (float)Math.toRadians(180.0f - this.field_70177_z + (float)this.frontDirection.func_176736_b() * 90.0f);
                vec = vec.setX(this.field_70159_w);
                vec = vec.setZ(this.field_70179_y);
                vec = vec.rotateAroundY(yaw);
                vec = vec.setX(vec.field_72450_a * 0.9);
                vec = vec.setZ(vec.field_72449_c - throttle * (double)0.005f * (double)this.capabilities.getSpeedMult());
                vec = vec.rotateAroundY(-yaw);
                this.field_70159_w = vec.field_72450_a;
                this.field_70179_y = vec.field_72449_c;
            } else if (DavincisVesselsMod.INSTANCE.getNetworkConfig().getShared().shipControlType == 0 && throttle > 0.0) {
                double dsin = -Math.sin(Math.toRadians(this.func_184179_bs().field_70177_z));
                double dcos = Math.cos(Math.toRadians(this.func_184179_bs().field_70177_z));
                this.field_70159_w += dsin * (double)0.005f * (double)this.capabilities.speedMultiplier;
                this.field_70179_y += dcos * (double)0.005f * (double)this.capabilities.speedMultiplier;
            }
        }
        if (this.controller.getShipControl() != 0) {
            if (this.controller.getShipControl() == 4) {
                this.alignToGrid(true);
            } else if (this.isBraking()) {
                this.field_70159_w *= (double)this.capabilities.brakeMult;
                this.field_70179_y *= (double)this.capabilities.brakeMult;
                if (this.isFlying()) {
                    this.field_70181_x *= (double)this.capabilities.brakeMult;
                }
            } else if (this.controller.getShipControl() < 3 && this.capabilities.canFly()) {
                int i;
                if (this.controller.getShipControl() == 2) {
                    this.setFlying(true);
                    i = 1;
                } else {
                    i = -1;
                }
                this.field_70181_x += (double)((float)i * 0.004f * this.capabilities.getLiftMult());
            }
        }
    }

    public boolean func_70104_M() {
        return !this.field_70128_L && this.func_184179_bs() == null && this.driftCooldown <= 0;
    }

    public boolean isFlying() {
        return this.capabilities.canFly() && (super.isFlying() || this.controller.getShipControl() == 2) || this.getSubmerge();
    }

    public boolean areSubmerged() {
        int belowWater = this.getBelowWater();
        return this.getSubmerge() && belowWater > 0;
    }

    public void readMovingWorldSpawnData(ByteBuf data) {
    }

    public float getXRenderScale() {
        return 1.0f;
    }

    public float getYRenderScale() {
        return 1.0f;
    }

    public float getZRenderScale() {
        return 1.0f;
    }

    public MovingWorldAssemblyInteractor getAssemblyInteractor() {
        if (this.shipAssemblyInteractor == null) {
            this.shipAssemblyInteractor = (ShipAssemblyInteractor)this.getNewAssemblyInteractor();
        }
        return this.shipAssemblyInteractor;
    }

    public void setAssemblyInteractor(MovingWorldAssemblyInteractor interactor) {
    }

    public void fillAirBlocks(Set<BlockPos> set, BlockPos pos) {
        super.fillAirBlocks(set, pos);
    }

    public ShipControllerCommon getController() {
        return this.controller;
    }

    public boolean canSubmerge() {
        return !this.field_70180_af.func_187228_d() ? (Boolean)this.field_70180_af.func_187225_a(CAN_SUBMERGE) : false;
    }
}

