/*
 * Decompiled with CFR 0.152.
 */
package lodsofemone;

import javax.annotation.Nonnull;
import lodsofemone.ItemCoin;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="lodsofemone", acceptedMinecraftVersions="[1.12, 1.13)", dependencies="required-after:ftbmoney", guiFactory="lodsofemone.GuiFactory")
@Mod.EventBusSubscriber
public class LodsOfEmone {
    public static final String MODID = "lodsofemone";
    public static Configuration config;
    public static int[] coinSmallValues;
    public static int[] coinBigValues;
    @GameRegistry.ObjectHolder(value="lodsofemone:coin_small")
    public static Item COIN_SMALL;
    @GameRegistry.ObjectHolder(value="lodsofemone:coin_big")
    public static Item COIN_BIG;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        LodsOfEmone.loadConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase(MODID)) {
            LodsOfEmone.loadConfig();
        }
    }

    public static void loadConfig() {
        coinSmallValues = config.get("coins", "coinSmallValues", new int[]{1, 10, 25, 50}, "List of small coin denominations that show up in JEI.").getIntList();
        coinBigValues = config.get("coins", "coinBigValues", new int[]{100, 200, 500, 1000, 5000, 10000}, "List of big coin denominations that show up in JEI.").getIntList();
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        COIN_SMALL = ((Item)new ItemCoin(){

            @Override
            public int[] getDenominations() {
                return coinSmallValues;
            }
        }.setRegistryName(new ResourceLocation(MODID, "coin_small"))).func_77655_b("coin_small").func_77637_a(CreativeTabs.field_78035_l);
        event.getRegistry().register((IForgeRegistryEntry)COIN_SMALL);
        COIN_BIG = ((Item)new ItemCoin(){

            @Override
            public int[] getDenominations() {
                return coinBigValues;
            }
        }.setRegistryName(new ResourceLocation(MODID, "coin_big"))).func_77655_b("coin_big").func_77637_a(CreativeTabs.field_78035_l);
        event.getRegistry().register((IForgeRegistryEntry)COIN_BIG);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        LodsOfEmone.registerItemModel(COIN_SMALL, 0, "inventory");
        LodsOfEmone.registerItemModel(COIN_BIG, 0, "inventory");
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModel(@Nonnull Item item, int meta, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
    }
}

