/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientInstanceWrapper;
import org.cyclops.cyclopscore.ingredient.collection.IngredientHashSet;
import org.cyclops.cyclopscore.ingredient.collection.IngredientMapAdapter;
import org.cyclops.cyclopscore.ingredient.collection.IngredientSet;

public abstract class IngredientMapWrappedAdapter<T, M, V, C extends Map<IngredientInstanceWrapper<T, M>, V>>
extends IngredientMapAdapter<T, M, V> {
    private final C collection;

    protected IngredientMapWrappedAdapter(IngredientComponent<T, M> component, C collection) {
        super(component);
        this.collection = collection;
    }

    protected C getCollection() {
        return this.collection;
    }

    protected IngredientInstanceWrapper<T, M> wrap(T instance) {
        return this.getComponent().wrap(instance);
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    @Override
    @Nullable
    public V put(T key, V value) {
        return this.collection.put(this.wrap(key), value);
    }

    @Override
    @Nullable
    public V remove(T key) {
        return this.collection.remove(this.wrap(key));
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean containsValue(V value) {
        return this.collection.containsValue(value);
    }

    @Override
    @Nullable
    public V get(T key) {
        return this.collection.get(this.wrap(key));
    }

    @Override
    public IngredientSet<T, M> keySet() {
        return new IngredientHashSet(this.getComponent(), Sets.newHashSet(this.collection.keySet()));
    }

    @Override
    public Collection<V> values() {
        return this.collection.values();
    }

    @Override
    public Iterator<Map.Entry<T, V>> iterator() {
        return Iterators.transform(this.collection.keySet().iterator(), key -> new AbstractMap.SimpleEntry(key.getInstance(), this.collection.get(key)));
    }
}

