/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adlods.ore.DepositGenResult;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Indicator
implements IHaveConfig {
    public static int searchRadius = 4;
    protected final UnitConfig config;
    protected final UnitId id;

    public Indicator(UnitConfig config, String headCategory) {
        this.config = config;
        String category = this.expandClassCategory(headCategory);
        if (config != null) {
            config.setCategoryComment(category, "Defines the above-ground indicator for this deposit (e.g., a rare flower)");
        }
        this.id = ForgeConfig.getUnitId((ForgeConfig)config, (String)category, (String)"id", (UnitId)UnitId.EMPTY, (String)"Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUnit name will be automatically converted to ore dictionary name with reverse word order (example: oreIronBlack).\nUse '*' char as meta value to specify all possible values.\nTo define multiple block states, you can use block properties instead of meta. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use just ore dictionary name as full id.\n");
    }

    public UnitId getId() {
        return this.id;
    }

    public boolean placeFor(World world, DepositGenResult result) {
        if (result.size < 1) {
            return false;
        }
        if (this.getId().isEmpty()) {
            return false;
        }
        IBlockState state = this.getId().getIBlockState();
        if (state == null) {
            return false;
        }
        BlockPos pos = this.findPosition(world, result.pos, searchRadius);
        if (pos == null) {
            return false;
        }
        return world.func_175656_a(pos, state);
    }

    @Nullable
    protected BlockPos findPosition(World world, BlockPos centerPos, int radius) {
        IBlockState indicatorState = this.getId().getIBlockState();
        if (indicatorState == null) {
            return null;
        }
        for (int r = 0; r <= radius; ++r) {
            block1: for (BlockPos startPos : ForgeWorld.Position.getAroundHoriz((BlockPos)centerPos, (int)r, (boolean)true)) {
                if (!world.func_175667_e(startPos)) continue;
                int topY = ForgeBounds.HEIGHT.getIntBounds().getMax();
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(startPos);
                for (int y = topY; y > 0; --y) {
                    pos.func_185336_p(y);
                    IBlockState state = world.func_180495_p((BlockPos)pos);
                    Block block = state.func_177230_c();
                    Material material = state.func_185904_a();
                    if (!material.func_76230_c() || material.func_76224_d() || block.isLeaves(state, (IBlockAccess)world, (BlockPos)pos) || block.isFoliage((IBlockAccess)world, (BlockPos)pos) || block instanceof BlockHugeMushroom) continue;
                    BlockPos placePos = pos.func_177984_a();
                    if (!indicatorState.func_177230_c().func_176196_c(world, placePos)) continue block1;
                    return placePos;
                }
            }
        }
        return null;
    }

    public ForgeConfig getConfig() {
        return this.config;
    }
}

