/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.world;

import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adlods.ore.DepositGenResult;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class WorldData {
    static final Map<World, WorldData> DATA_MAP = new ConcurrentHashMap<World, WorldData>();
    protected final Map<ChunkPos, DepositGenResult> generatedDeposits = new ConcurrentHashMap<ChunkPos, DepositGenResult>();

    @Nonnull
    public static WorldData getData(World world) {
        WorldData data = DATA_MAP.get(world);
        if (data == null) {
            data = new WorldData();
            DATA_MAP.put(world, data);
        }
        return data;
    }

    @SubscribeEvent
    public static void onWorldUnloaded(WorldEvent.Unload event) {
        DATA_MAP.remove(event.getWorld());
    }

    @SubscribeEvent
    public static void onChunkDataLoading(ChunkDataEvent.Load event) {
        World world = event.getWorld();
        if (!ForgeWorld.isServerSide((World)world)) {
            return;
        }
        NBTTagCompound compound = event.getData();
        DepositGenResult result = DepositGenResult.EMPTY.readFrom(compound);
        WorldData.getData(world).addDepositGenResult(result);
    }

    @SubscribeEvent
    public static void onChunkDataSaving(ChunkDataEvent.Save event) {
        World world = event.getWorld();
        if (!ForgeWorld.isServerSide((World)world)) {
            return;
        }
        DepositGenResult deposit = WorldData.getData((World)world).generatedDeposits.get(event.getChunk().func_76632_l());
        if (deposit != null) {
            deposit.writeTo(event.getData());
        }
    }

    public void addDepositGenResult(DepositGenResult result) {
        if (!result.isEmpty()) {
            this.generatedDeposits.put(new ChunkPos(result.pos), result);
        }
    }

    public Map<ChunkPos, DepositGenResult> getGeneratedDeposits() {
        return Collections.unmodifiableMap(this.generatedDeposits);
    }
}

