/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity;

import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.events.LeafHandler;
import epicsquid.mysticalworld.init.ModItems;
import epicsquid.mysticalworld.init.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntitySilkworm
extends EntityAnimal {
    public static ResourceLocation LOOT_TABLE = new ResourceLocation("mysticalworld", "entity/silkworm");
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntitySilkworm.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LEAVES_CONSUMED = EntityDataManager.func_187226_a(EntitySilkworm.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final int MAX_SIZE = 120;
    private EntityItem leafTarget;
    private int lastTickPlayed = 0;

    public EntitySilkworm(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 1;
        this.func_70105_a(0.8f, 0.6f);
    }

    public void setLeafTarget(EntityItem leaf) {
        this.leafTarget = leaf;
    }

    public EntityItem getLeafTarget() {
        return this.leafTarget;
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)0);
        this.field_70180_af.func_187214_a(LEAVES_CONSUMED, (Object)0);
    }

    public int getLeavesConsumed() {
        return (Integer)this.field_70180_af.func_187225_a(LEAVES_CONSUMED);
    }

    public void setLeavesConsumed(int amount) {
        this.field_70180_af.func_187227_b(LEAVES_CONSUMED, (Object)amount);
        this.field_70180_af.func_187217_b(LEAVES_CONSUMED);
    }

    public void resetLeaves() {
        this.field_70180_af.func_187227_b(LEAVES_CONSUMED, (Object)0);
        this.field_70180_af.func_187217_b(LEAVES_CONSUMED);
    }

    private boolean shouldPlaySound() {
        return this.field_70173_aa - this.lastTickPlayed > 8;
    }

    public void eatLeaves() {
        this.incLeaves();
        for (int i = 0; i < 1 + this.field_70146_Z.nextInt(3); ++i) {
            this.grow();
        }
        this.func_70691_i(1.0f);
        if (this.shouldPlaySound()) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.Silkworm.EAT, SoundCategory.NEUTRAL, 0.5f, 1.2f + this.field_70146_Z.nextFloat() * 0.02f);
            this.lastTickPlayed = this.field_70173_aa;
        }
    }

    private void incLeaves() {
        this.field_70180_af.func_187227_b(LEAVES_CONSUMED, (Object)(this.getLeavesConsumed() + 1));
        this.field_70180_af.func_187217_b(LEAVES_CONSUMED);
    }

    public int getSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    public void setSize(int size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)size);
        this.field_70180_af.func_187217_b(SIZE);
    }

    private void incSize() {
        if (!this.func_70631_g_()) {
            this.field_70180_af.func_187227_b(SIZE, (Object)(this.getSize() + 1));
            this.field_70180_af.func_187217_b(SIZE);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (LeafHandler.getLeafItems().contains(itemstack.func_77973_b())) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.eatLeaves();
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public float func_70047_e() {
        return 0.1f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
            return ModSounds.Silkworm.AMBIENT;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.Silkworm.HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.Silkworm.DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(ModSounds.Silkworm.STEP, 0.15f, 1.3f + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f));
    }

    @Nullable
    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    protected float func_70599_aP() {
        return 0.2f;
    }

    protected float func_70647_i() {
        return 1.3f + this.field_70146_Z.nextFloat() - 0.5f;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSize(compound.func_74762_e("Size"));
        this.setLeavesConsumed(compound.func_74762_e("Leaves"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Size", this.getSize());
        compound.func_74768_a("Leaves", this.getLeavesConsumed());
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        float[] ret = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        PotionEffect potioneffect = this.func_70660_b(MobEffects.field_76430_j);
        float f = potioneffect == null ? 0.0f : (float)(potioneffect.func_76458_c() + 1);
        int i = MathHelper.func_76123_f((float)((distance - 3.0f - f) * damageMultiplier));
        if (i > 0) {
            this.func_184185_a(this.func_184588_d(i), 1.0f, 1.0f);
            int j = MathHelper.func_76128_c((double)this.field_70165_t);
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - 0.2));
            int l = MathHelper.func_76128_c((double)this.field_70161_v);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(j, k, l));
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                SoundType soundtype = iblockstate.func_177230_c().getSoundType(iblockstate, this.field_70170_p, new BlockPos(j, k, l), (Entity)this);
                this.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(ConfigManager.safeInt(ConfigManager.silkworm.growthChance)) == 0) {
            this.grow();
        }
    }

    public void grow() {
        int size = this.getSize();
        if (size == 120) {
            this.setSize(0);
            if (this.func_70613_aW()) {
                int quantity = Math.max(1, Math.min(5, this.field_70146_Z.nextInt(Math.max(this.getLeavesConsumed() % 8, 1))));
                this.func_145779_a(ModItems.silk_cocoon, quantity);
                this.resetLeaves();
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.Silkworm.PLOP, SoundCategory.NEUTRAL, 0.5f, 1.2f + this.field_70146_Z.nextFloat() - 0.5f);
            }
        } else {
            this.incSize();
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }
}

