/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.proxy;

import epicsquid.mysticallib.util.Util;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.events.LeafHandler;
import epicsquid.mysticalworld.init.ModEntities;
import epicsquid.mysticalworld.init.ModItems;
import epicsquid.mysticalworld.integration.endercore.EndercoreHarvest;
import epicsquid.mysticalworld.integration.harvest.HarvestIntegration;
import epicsquid.mysticalworld.integration.jer.JERIntegration;
import epicsquid.mysticalworld.integration.patchouli.api.ConfigKeys;
import epicsquid.mysticalworld.loot.conditions.HasHorns;
import epicsquid.mysticalworld.loot.conditions.IsLava;
import epicsquid.mysticalworld.loot.conditions.IsObsidian;
import epicsquid.mysticalworld.world.OreGenerator;
import epicsquid.mysticalworld.world.StructureGenerator;
import epicsquid.mysticalworld.world.WorldGeneratorTrees;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommonProxy {
    private static ResourceLocation BARROW = new ResourceLocation("mysticalworld", "barrow");
    private static ResourceLocation HUT = new ResourceLocation("mysticalworld", "hut");
    private StructureGenerator hutGenerator;
    private StructureGenerator barrowGenerator;
    private WorldGeneratorTrees treeGenerator;

    public void preInit(FMLPreInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)1);
        ModEntities.registerLootTables();
    }

    public void init(FMLInitializationEvent event) {
        ModItems.registerOredict();
        if (Loader.isModLoaded((String)"jeresources")) {
            JERIntegration.init();
        }
        if (Loader.isModLoaded((String)"endercore")) {
            EndercoreHarvest.init();
        }
        LootConditionManager.func_186639_a((LootCondition.Serializer)new HasHorns.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new IsLava.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new IsObsidian.Serializer());
        if (ConfigManager.BarrowDistance != -1) {
            this.barrowGenerator = new StructureGenerator(BARROW, 10, () -> {
                switch (Util.rand.nextInt(6)) {
                    case 0: 
                    case 1: {
                        return EntitySkeleton.class;
                    }
                }
                return EntityZombie.class;
            }, ConfigManager.BarrowDistance);
            GameRegistry.registerWorldGenerator((IWorldGenerator)this.barrowGenerator, (int)400);
        }
        if (ConfigManager.HutDistance != -1) {
            this.hutGenerator = new StructureGenerator(HUT, 6, () -> {
                if (Util.rand.nextInt(4) == 0) {
                    return EntityWitch.class;
                }
                return EntityZombie.class;
            }, ConfigManager.HutDistance);
            GameRegistry.registerWorldGenerator((IWorldGenerator)this.hutGenerator, (int)400);
        }
        this.treeGenerator = new WorldGeneratorTrees();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.treeGenerator, (int)400);
        ConfigKeys.init();
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        if (Loader.isModLoaded((String)"harvest")) {
            HarvestIntegration.init();
        }
        LeafHandler.getLeafBlocks();
    }

    public void serverStarted(FMLServerStartedEvent event) {
    }
}

