/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.tools;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;

public class Pairs {
    public static <T> Iterable<T> both(Iterable<? extends Pair<T, T>> set) {
        return Sets.newHashSet((Iterable)Iterables.concat((Iterable)StreamSupport.stream(set.spliterator(), false).map(arg_0 -> Pairs.leftFunction().apply(arg_0)).collect(Collectors.toList()), (Iterable)StreamSupport.stream(set.spliterator(), false).map(arg_0 -> Pairs.rightFunction().apply(arg_0)).collect(Collectors.toList())));
    }

    public static <T> Function<Pair<T, T>, T> rightFunction() {
        return input -> input.getRight();
    }

    public static <T> Function<Pair<T, T>, T> leftFunction() {
        return input -> input.getLeft();
    }

    public static <L, R> Iterable<Pair<L, R>> pairLeft(L left, Iterable<R> right) {
        return StreamSupport.stream(right.spliterator(), false).map(input -> Pair.of((Object)left, (Object)input)).collect(Collectors.toList());
    }

    public static <L, R> Iterable<Pair<L, R>> pairRight(Iterable<L> left, R right) {
        return StreamSupport.stream(left.spliterator(), false).map(input -> Pair.of((Object)input, (Object)right)).collect(Collectors.toList());
    }

    public static <L, R> Iterable<Pair<L, R>> of(final Iterable<L> left, final Iterable<R> right) {
        return new FluentIterable<Pair<L, R>>(){

            public Iterator<Pair<L, R>> iterator() {
                return new PairIterator(left.iterator(), right.iterator());
            }
        };
    }

    public static <L, R> List<Pair<L, R>> of(List<L> left, List<R> right) {
        return new PairList<L, R>(left, right);
    }

    protected static class PairList<L, R>
    extends AbstractList<Pair<L, R>> {
        protected List<L> left;
        protected List<R> right;

        public PairList(List<L> left, List<R> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Pair<L, R> get(int index) {
            return Pair.of(this.left.get(index), this.right.get(index));
        }

        @Override
        public int size() {
            return Math.min(this.left.size(), this.right.size());
        }

        @Override
        public Iterator<Pair<L, R>> iterator() {
            return new PairIterator<L, R>(this.left.listIterator(), this.right.listIterator());
        }

        @Override
        public boolean remove(Object o) {
            return this.left.remove(((Pair)o).getLeft()) && this.right.remove(((Pair)o).getRight());
        }
    }

    protected static class PairIterator<L, R>
    implements Iterator<Pair<L, R>> {
        protected Iterator<L> left;
        protected Iterator<R> right;

        public PairIterator(Iterator<L> left, Iterator<R> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean hasNext() {
            return this.left.hasNext() && this.right.hasNext();
        }

        @Override
        public Pair<L, R> next() {
            return Pair.of(this.left.next(), this.right.next());
        }

        @Override
        public void remove() {
            this.left.remove();
            this.right.remove();
        }
    }
}

