/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.events.handlers;

import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.world.gen.feature.decoration.RCBiomeDecorator;
import ivorius.reccomplex.world.gen.feature.sapling.RCSaplingGenerator;
import ivorius.reccomplex.world.gen.feature.structure.MapGenStructureHook;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RCTerrainGenEventHandler {
    private static boolean hasAmountData(DecorateBiomeEvent.Decorate event) {
        try {
            event.getClass().getDeclaredMethod("getModifiedAmount", new Class[0]);
            event.getClass().getDeclaredMethod("setModifiedAmount", Integer.TYPE);
            return (Boolean)event.getClass().getDeclaredMethod("hasAmountData", new Class[0]).invoke((Object)event, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int getModifiedAmount(DecorateBiomeEvent.Decorate event) {
        try {
            return (Integer)event.getClass().getDeclaredMethod("getModifiedAmount", new Class[0]).invoke((Object)event, new Object[0]);
        }
        catch (Exception ignored) {
            return -1;
        }
    }

    private static void setModifiedAmount(DecorateBiomeEvent.Decorate event, int amount) {
        try {
            event.getClass().getDeclaredMethod("setModifiedAmount", Integer.TYPE).invoke((Object)event, amount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void register() {
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onSaplingGrow(SaplingGrowTreeEvent event) {
        if (event.getWorld() instanceof WorldServer && RCSaplingGenerator.maybeGrowSapling((WorldServer)event.getWorld(), event.getPos(), event.getRand())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onDecoration(DecorateBiomeEvent.Decorate event) {
        RCBiomeDecorator.DecorationType type;
        if (event.getWorld() instanceof WorldServer && (type = RCBiomeDecorator.DecorationType.getDecorationType(event)) != null) {
            int amount;
            if (RCTerrainGenEventHandler.hasAmountData(event) && (amount = RCTerrainGenEventHandler.getModifiedAmount(event)) >= 0) {
                RCTerrainGenEventHandler.setModifiedAmount(event, RCBiomeDecorator.decorate((WorldServer)event.getWorld(), event.getRand(), event.getPos(), type, amount));
            } else {
                Event.Result result = RCBiomeDecorator.decorate((WorldServer)event.getWorld(), event.getRand(), event.getPos(), type);
                if (result != null) {
                    event.setResult(result);
                }
            }
        }
    }

    @SubscribeEvent
    public void onInitMapGen(InitMapGenEvent event) {
        if (RCConfig.decorationHacks) {
            InitMapGenEvent.EventType type = event.getType();
            switch (type) {
                case OCEAN_MONUMENT: {
                    final MapGenStructureHook hook = new MapGenStructureHook((MapGenStructure)event.getNewGen(), RCBiomeDecorator.DecorationType.OCEAN_MONUMENT);
                    event.setNewGen((MapGenBase)new StructureOceanMonument(){

                        public String func_143025_a() {
                            return hook.func_143025_a();
                        }

                        public boolean func_175794_a(World worldIn, Random randomIn, ChunkPos chunkCoord) {
                            return hook.func_175794_a(worldIn, randomIn, chunkCoord);
                        }

                        public boolean func_175795_b(BlockPos pos) {
                            return hook.func_175795_b(pos);
                        }

                        public boolean func_175796_a(World worldIn, BlockPos pos) {
                            return hook.func_175796_a(worldIn, pos);
                        }

                        @Nullable
                        public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
                            return hook.func_180706_b(worldIn, pos, findUnexplored);
                        }

                        public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
                            hook.func_186125_a(worldIn, x, z, primer);
                        }
                    });
                    break;
                }
                case SCATTERED_FEATURE: {
                    final MapGenStructureHook hook = new MapGenStructureHook((MapGenStructure)event.getNewGen(), RCBiomeDecorator.DecorationType.SCATTERED_FEATURE);
                    event.setNewGen((MapGenBase)new MapGenScatteredFeature(){

                        public String func_143025_a() {
                            return hook.func_143025_a();
                        }

                        public boolean func_175794_a(World worldIn, Random randomIn, ChunkPos chunkCoord) {
                            return hook.func_175794_a(worldIn, randomIn, chunkCoord);
                        }

                        public boolean func_175795_b(BlockPos pos) {
                            return hook.func_175795_b(pos);
                        }

                        public boolean func_175796_a(World worldIn, BlockPos pos) {
                            return hook.func_175796_a(worldIn, pos);
                        }

                        @Nullable
                        public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
                            return hook.func_180706_b(worldIn, pos, findUnexplored);
                        }

                        public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
                            hook.func_186125_a(worldIn, x, z, primer);
                        }
                    });
                    break;
                }
                case VILLAGE: {
                    final MapGenStructureHook hook = new MapGenStructureHook((MapGenStructure)event.getNewGen(), RCBiomeDecorator.DecorationType.VILLAGE);
                    event.setNewGen((MapGenBase)new MapGenVillage(){

                        public String func_143025_a() {
                            return hook.func_143025_a();
                        }

                        public boolean func_175794_a(World worldIn, Random randomIn, ChunkPos chunkCoord) {
                            return hook.func_175794_a(worldIn, randomIn, chunkCoord);
                        }

                        public boolean func_175795_b(BlockPos pos) {
                            return hook.func_175795_b(pos);
                        }

                        public boolean func_175796_a(World worldIn, BlockPos pos) {
                            return hook.func_175796_a(worldIn, pos);
                        }

                        @Nullable
                        public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
                            return hook.func_180706_b(worldIn, pos, findUnexplored);
                        }

                        public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
                            hook.func_186125_a(worldIn, x, z, primer);
                        }
                    });
                    break;
                }
                case NETHER_BRIDGE: {
                    final MapGenStructureHook hook = new MapGenStructureHook((MapGenStructure)event.getNewGen(), RCBiomeDecorator.DecorationType.NETHER_BRIDGE);
                    event.setNewGen((MapGenBase)new MapGenNetherBridge(){

                        public String func_143025_a() {
                            return hook.func_143025_a();
                        }

                        public boolean func_175794_a(World worldIn, Random randomIn, ChunkPos chunkCoord) {
                            return hook.func_175794_a(worldIn, randomIn, chunkCoord);
                        }

                        public boolean func_175795_b(BlockPos pos) {
                            return hook.func_175795_b(pos);
                        }

                        public boolean func_175796_a(World worldIn, BlockPos pos) {
                            return hook.func_175796_a(worldIn, pos);
                        }

                        @Nullable
                        public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
                            return hook.func_180706_b(worldIn, pos, findUnexplored);
                        }

                        public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
                            hook.func_186125_a(worldIn, x, z, primer);
                        }
                    });
                    break;
                }
                case STRONGHOLD: {
                    final MapGenStructureHook hook = new MapGenStructureHook((MapGenStructure)event.getNewGen(), RCBiomeDecorator.DecorationType.STRONGHOLD);
                    event.setNewGen((MapGenBase)new MapGenStronghold(){

                        public String func_143025_a() {
                            return hook.func_143025_a();
                        }

                        public boolean func_175794_a(World worldIn, Random randomIn, ChunkPos chunkCoord) {
                            return hook.func_175794_a(worldIn, randomIn, chunkCoord);
                        }

                        public boolean func_175795_b(BlockPos pos) {
                            return hook.func_175795_b(pos);
                        }

                        public boolean func_175796_a(World worldIn, BlockPos pos) {
                            return hook.func_175796_a(worldIn, pos);
                        }

                        @Nullable
                        public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
                            return hook.func_180706_b(worldIn, pos, findUnexplored);
                        }

                        public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
                            hook.func_186125_a(worldIn, x, z, primer);
                        }
                    });
                    break;
                }
                case MINESHAFT: {
                    final MapGenStructureHook hook = new MapGenStructureHook((MapGenStructure)event.getNewGen(), RCBiomeDecorator.DecorationType.MINESHAFT);
                    event.setNewGen((MapGenBase)new MapGenMineshaft(){

                        public String func_143025_a() {
                            return hook.func_143025_a();
                        }

                        public boolean func_175794_a(World worldIn, Random randomIn, ChunkPos chunkCoord) {
                            return hook.func_175794_a(worldIn, randomIn, chunkCoord);
                        }

                        public boolean func_175795_b(BlockPos pos) {
                            return hook.func_175795_b(pos);
                        }

                        public boolean func_175796_a(World worldIn, BlockPos pos) {
                            return hook.func_175796_a(worldIn, pos);
                        }

                        @Nullable
                        public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
                            return hook.func_180706_b(worldIn, pos, findUnexplored);
                        }

                        public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
                            hook.func_186125_a(worldIn, x, z, primer);
                        }
                    });
                }
            }
        }
    }
}

