/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.container;

import io.netty.buffer.ByteBuf;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.container.IvGuiHandler;
import ivorius.reccomplex.network.PacketOpenGui;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class IvGuiRegistry {
    public static final IvGuiRegistry INSTANCE = new IvGuiRegistry();
    private final Map<String, IvGuiHandler> handlers = new HashMap<String, IvGuiHandler>();

    public void register(String modID, IvGuiHandler handler) {
        this.handlers.put(modID, handler);
    }

    public void openGui(EntityPlayer entityPlayer, String modid, int modGuiId, ByteBuf data) {
        IvGuiHandler handler = this.handlers.get(modid);
        if (handler == null) {
            return;
        }
        if (entityPlayer instanceof EntityPlayerMP && !(entityPlayer instanceof FakePlayer)) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entityPlayer;
            ByteBuf dataCopy = data.copy();
            Container remoteGuiContainer = handler.getServerGuiElement(modGuiId, entityPlayerMP, data);
            entityPlayerMP.func_71117_bO();
            entityPlayerMP.func_71128_l();
            int windowId = entityPlayerMP.field_71139_cq;
            RecurrentComplex.network.sendTo((IMessage)new PacketOpenGui(windowId, modid, modGuiId, dataCopy), entityPlayerMP);
            if (remoteGuiContainer != null) {
                entityPlayerMP.field_71070_bA = remoteGuiContainer;
                entityPlayerMP.field_71070_bA.field_75152_c = windowId;
                entityPlayerMP.field_71070_bA.func_75132_a((IContainerListener)entityPlayerMP);
            }
        } else if (!(entityPlayer instanceof FakePlayer)) {
            if (FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT)) {
                RecurrentComplex.network.sendToServer((IMessage)new PacketOpenGui(0, modid, modGuiId, data));
            } else {
                FMLLog.fine((String)"Invalid attempt to open a local GUI on a dedicated server. This is likely a bug. GUI ID: %s,%d", (Object[])new Object[]{modid, modGuiId});
            }
        }
    }

    public void openGuiJustClient(EntityPlayer entityPlayer, String modid, int modGuiId, ByteBuf data) {
        IvGuiHandler handler = this.handlers.get(modid);
        if (handler == null) {
            return;
        }
        Object guiContainer = handler.getClientGuiElement(modGuiId, entityPlayer, data);
        FMLCommonHandler.instance().showGuiScreen(guiContainer);
    }
}

