/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui;

import com.direwolf20.buildinggadgets.common.ModSounds;
import java.awt.Color;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class GuiButtonActionable
extends GuiButton {
    private Predicate<Boolean> action;
    private boolean selected;
    private boolean isSelectable;
    private Color selectedColor = Color.GREEN;
    private Color deselectedColor = new Color(255, 255, 255);
    private Color activeColor = this.deselectedColor;
    private ResourceLocation selectedTexture;
    private ResourceLocation deselectedTexture;
    private float alpha = 1.0f;

    public GuiButtonActionable(int x, int y, String texture, String message, boolean isSelectable, Predicate<Boolean> action) {
        super(0, x, y, 25, 25, message);
        this.isSelectable = isSelectable;
        this.action = action;
        this.setSelected(action.test(false));
        String assetLocation = "textures/gui/setting/%s.png";
        this.deselectedTexture = new ResourceLocation("buildinggadgets", String.format(assetLocation, texture));
        this.selectedTexture = !isSelectable ? this.deselectedTexture : new ResourceLocation("buildinggadgets", String.format(assetLocation, texture + "_selected"));
    }

    public GuiButtonActionable(int x, int y, String texture, String message, Predicate<Boolean> action) {
        this(x, y, texture, message, false, action);
    }

    public void setFaded(boolean faded) {
        this.alpha = faded ? 0.6f : 1.0f;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.activeColor = selected ? this.selectedColor : this.deselectedColor;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void func_146113_a(SoundHandler soundHandlerIn) {
        soundHandlerIn.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)ModSounds.BEEP.getSound(), (float)(this.selected ? 0.6f : 1.0f)));
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        super.func_146116_c(mc, mouseX, mouseY);
        if (mouseX < this.field_146128_h || mouseY < this.field_146129_i || mouseX >= this.field_146128_h + this.field_146120_f || mouseY >= this.field_146129_i + this.field_146121_g) {
            return false;
        }
        this.action.test(true);
        if (!this.isSelectable) {
            return false;
        }
        this.setSelected(!this.selected);
        return true;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_146125_m) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)((float)this.activeColor.getRed() / 255.0f), (float)((float)this.activeColor.getGreen() / 255.0f), (float)((float)this.activeColor.getBlue() / 255.0f), (float)0.15f);
        this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 0, this.field_146120_f, this.field_146121_g);
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.selected ? this.selectedTexture : this.deselectedTexture);
        GuiButtonActionable.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)0.0f, (float)0.0f, (int)this.field_146120_f, (int)this.field_146121_g, (float)this.field_146120_f, (float)this.field_146121_g);
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        if (mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g) {
            this.func_73731_b(Minecraft.func_71410_x().field_71466_p, this.field_146126_j, mouseX > scaledresolution.func_78326_a() / 2 ? mouseX + 2 : mouseX - Minecraft.func_71410_x().field_71466_p.func_78256_a(this.field_146126_j), mouseY - 10, this.activeColor.getRGB());
        }
    }
}

