/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui.materiallist;

import com.direwolf20.buildinggadgets.client.gui.DireButton;
import com.direwolf20.buildinggadgets.client.gui.base.GuiBase;
import com.direwolf20.buildinggadgets.client.gui.materiallist.ScrollingMaterialList;
import com.direwolf20.buildinggadgets.client.gui.materiallist.SortingModes;
import com.direwolf20.buildinggadgets.client.util.AlignmentUtil;
import com.direwolf20.buildinggadgets.client.util.RenderUtil;
import com.direwolf20.buildinggadgets.common.items.ITemplate;
import com.direwolf20.buildinggadgets.common.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.common.tools.UniqueItem;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.Color;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.lwjgl.input.Mouse;

public class MaterialListGUI
extends GuiBase {
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTONS_PADDING = 4;
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("buildinggadgets", "textures/gui/material_list.png");
    public static final int BACKGROUND_WIDTH = 256;
    public static final int BACKGROUND_HEIGHT = 200;
    public static final int BORDER_SIZE = 4;
    public static final int WINDOW_WIDTH = 248;
    public static final int WINDOW_HEIGHT = 192;
    public static final int BUTTON_CLOSE_ID = 0;
    public static final int BUTTON_SORTING_MODES_ID = 1;
    public static final int BUTTON_COPY_LIST_ID = 2;
    public static final String PATTERN_SIMPLE = "%s: %d";
    public static final String PATTERN_DETAILED = "%s: %d (%s, %s)";
    private int backgroundX;
    private int backgroundY;
    private String title;
    private int titleLeft;
    private int titleTop;
    private ItemStack template;
    private List<ItemStack> materials;
    private IntList available;
    private ScrollingMaterialList scrollingList;
    private SortingModes sortingMode = SortingModes.NAME;
    private DireButton buttonClose;
    private DireButton buttonSortingModes;
    private DireButton buttonCopyList;
    private int hoveringTextX;
    private int hoveringTextY;
    private List<String> hoveringText;

    public MaterialListGUI(ItemStack template) {
        this.template = template;
    }

    public void func_73866_w_() {
        ITemplate item = (ITemplate)this.template.func_77973_b();
        this.backgroundX = AlignmentUtil.getXForAlignedCenter(256, 0, this.field_146294_l);
        this.backgroundY = AlignmentUtil.getYForAlignedCenter(200, 0, this.field_146295_m);
        this.title = I18n.func_135052_a((String)"gui.buildinggadgets.materialList.title", (Object[])new Object[0]);
        this.titleTop = AlignmentUtil.getYForAlignedCenter(this.field_146289_q.field_78288_b, this.backgroundY, this.getWindowTopY() + 24);
        this.titleLeft = AlignmentUtil.getXForAlignedCenter(this.field_146289_q.func_78256_a(this.title), this.backgroundX, this.getWindowRightX());
        this.materials = item.getItemCountMap(this.template).entrySet().stream().map(e -> new ItemStack(((UniqueItem)e.getElement()).item, e.getCount(), ((UniqueItem)e.getElement()).meta)).collect(Collectors.toList());
        this.sortMaterialList();
        this.updateAvailableMaterials();
        this.scrollingList = new ScrollingMaterialList(this, 256, 200);
        int buttonY = this.getWindowBottomY() - 26;
        this.buttonClose = new DireButton(0, 0, buttonY, 0, 20, I18n.func_135052_a((String)"gui.buildinggadgets.materialList.button.close", (Object[])new Object[0]));
        this.buttonSortingModes = new DireButton(1, 0, buttonY, 0, 20, this.sortingMode.getLocalizedName());
        this.buttonCopyList = new DireButton(2, 0, buttonY, 0, 20, I18n.func_135052_a((String)"gui.buildinggadgets.materialList.button.copyList", (Object[])new Object[0]));
        this.func_189646_b(this.buttonSortingModes);
        this.func_189646_b(this.buttonCopyList);
        this.func_189646_b(this.buttonClose);
        this.calculateButtonsWidthAndX();
    }

    private String stringify(boolean detailed) {
        if (detailed) {
            return this.stringifyDetailed();
        }
        return this.stringifySimple();
    }

    private String stringifyDetailed() {
        return this.materials.stream().map(item -> String.format(PATTERN_DETAILED, item.func_82833_r(), item.func_190916_E(), item.func_77973_b().getRegistryName(), InventoryManipulation.formatItemCount(item.func_77976_d(), item.func_190916_E()))).collect(Collectors.joining("\n"));
    }

    private String stringifySimple() {
        return this.materials.stream().map(item -> String.format(PATTERN_SIMPLE, item.func_82833_r(), item.func_190916_E())).collect(Collectors.joining("\n"));
    }

    public void func_73863_a(int mouseX, int mouseY, float particleTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        RenderUtil.drawTexturedModalRect(this.backgroundX, this.backgroundY, 256, 200);
        this.scrollingList.drawScreen(mouseX, mouseY, particleTicks);
        this.func_73731_b(this.field_146289_q, this.title, this.titleLeft, this.titleTop, Color.WHITE.getRGB());
        super.func_73863_a(mouseX, mouseY, particleTicks);
        if (this.hoveringText != null) {
            RenderHelper.func_74520_c();
            this.func_146283_a(this.hoveringText, this.hoveringTextX, this.hoveringTextY);
            GlStateManager.func_179140_f();
            this.hoveringText = null;
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mx = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int my = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.scrollingList.handleMouseInput(mx, my);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                Minecraft.func_71410_x().field_71439_g.func_71053_j();
                return;
            }
            case 1: {
                this.sortingMode = this.sortingMode.next();
                this.buttonSortingModes.field_146126_j = this.sortingMode.getLocalizedName();
                this.sortMaterialList();
                this.updateAvailableMaterials();
                return;
            }
            case 2: {
                boolean detailed = GuiScreen.func_146271_m();
                GuiScreen.func_146275_d((String)this.stringify(detailed));
                String type = detailed ? I18n.func_135052_a((String)"gui.buildinggadgets.materialList.message.copiedMaterialList.detailed", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.buildinggadgets.materialList.message.copiedMaterialList.simple", (Object[])new Object[0]);
                this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("gui.buildinggadgets.materialList.message.copiedMaterialList", new Object[]{type}), true);
                return;
            }
        }
        this.scrollingList.actionPerformed(button);
    }

    public void func_73730_a(int startX, int endX, int y, int color) {
        super.func_73730_a(startX, endX, y, color);
    }

    private void updateAvailableMaterials() {
        this.available = InventoryManipulation.countItems(this.materials, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    private void calculateButtonsWidthAndX() {
        int amountButtons = this.field_146292_n.size();
        int amountMargins = amountButtons - 1;
        int totalMarginWidth = amountMargins * 4;
        int usableWidth = this.getWindowWidth();
        int buttonWidth = (usableWidth - totalMarginWidth) / amountButtons;
        int nextX = this.getWindowLeftX();
        for (GuiButton button : this.field_146292_n) {
            button.field_146120_f = buttonWidth;
            button.field_146128_h = nextX;
            nextX += buttonWidth + 4;
        }
    }

    private void sortMaterialList() {
        this.sortingMode.sortInplace(this.materials);
    }

    public boolean func_73868_f() {
        return false;
    }

    public int getWindowLeftX() {
        return this.backgroundX + 4;
    }

    public int getWindowRightX() {
        return this.backgroundX + 256 - 4;
    }

    public int getWindowTopY() {
        return this.backgroundY + 4;
    }

    public int getWindowBottomY() {
        return this.backgroundY + 200 - 4;
    }

    public int getWindowWidth() {
        return 248;
    }

    public int getWindowHeight() {
        return 192;
    }

    public List<ItemStack> getMaterials() {
        return this.materials;
    }

    public IntList getAvailable() {
        return this.available;
    }

    public void setTaskHoveringText(int x, int y, List<String> text) {
        this.hoveringTextX = x;
        this.hoveringTextY = y;
        this.hoveringText = text;
    }
}

