/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network;

import com.direwolf20.buildinggadgets.common.network.PacketBlockMap;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.tools.WorldSave;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRequestBlockMap
implements IMessage {
    private String UUID = "";
    private boolean isTemplate;

    public void fromBytes(ByteBuf buf) {
        this.UUID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.isTemplate = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.UUID);
        buf.writeBoolean(this.isTemplate);
    }

    public PacketRequestBlockMap() {
    }

    public PacketRequestBlockMap(String ID, boolean isTemplate) {
        this.UUID = ID;
        this.isTemplate = isTemplate;
    }

    public static class Handler
    implements IMessageHandler<PacketRequestBlockMap, IMessage> {
        public IMessage onMessage(PacketRequestBlockMap message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketRequestBlockMap message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            NBTTagCompound tagCompound = (message.isTemplate ? WorldSave.getTemplateWorldSave(player.field_70170_p) : WorldSave.getWorldSave(player.field_70170_p)).getCompoundFromUUID(message.UUID);
            if (tagCompound != null) {
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketBlockMap(tagCompound), player);
            }
        }
    }
}

