/*
 * Decompiled with CFR 0.152.
 */
package nc.block.item;

import java.util.List;
import javax.annotation.Nullable;
import nc.block.item.IMetaBlockName;
import nc.util.InfoHelper;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockMeta
extends ItemBlock {
    public final TextFormatting fixedColor;
    public final String[][] fixedInfo;
    public final String[][] info;

    public <T extends Enum<T>> ItemBlockMeta(Block block, Class<T> enumm, TextFormatting fixedColor, String[][] fixedTooltips, String[] ... tooltips) {
        super(block);
        if (!(block instanceof IMetaBlockName)) {
            throw new IllegalArgumentException(String.format("The given block %s is not an instance of IMetaBlockName!", block.func_149739_a()));
        }
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.fixedColor = fixedColor;
        this.fixedInfo = InfoHelper.buildFixedInfo(block.func_149739_a(), enumm, fixedTooltips);
        this.info = InfoHelper.buildInfo(block.func_149739_a(), enumm, tooltips);
    }

    public <T extends Enum<T>> ItemBlockMeta(Block block, Class<T> enumm, TextFormatting fixedColor, String[] ... tooltips) {
        this(block, enumm, fixedColor, InfoHelper.EMPTY_ARRAYS, tooltips);
    }

    public <T extends Enum<T>> ItemBlockMeta(Block block, Class<T> enumm, String[][] fixedTooltips, String[] ... tooltips) {
        this(block, enumm, TextFormatting.AQUA, fixedTooltips, tooltips);
    }

    public <T extends Enum<T>> ItemBlockMeta(Block block, Class<T> enumm, String[] ... tooltips) {
        this(block, enumm, InfoHelper.EMPTY_ARRAYS, tooltips);
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + ((IMetaBlockName)this.field_150939_a).getSpecialName(stack);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, tooltip, flag);
        int meta = itemStack.func_77960_j();
        if (this.info.length != 0 && this.info.length > meta && this.info[meta].length > 0) {
            InfoHelper.infoFull(tooltip, this.fixedColor, this.fixedInfo[meta], this.info[meta]);
        }
    }
}

