/*
 * Decompiled with CFR 0.152.
 */
package nc.block.property;

import nc.block.property.PropertySidedEnum;
import nc.tile.energy.ITileEnergy;
import nc.tile.internal.energy.EnergyConnection;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public interface ISidedEnergy {
    public static final PropertySidedEnum<EnergyConnection> ENERGY_DOWN = ISidedEnergy.energySide("down", EnumFacing.DOWN);
    public static final PropertySidedEnum<EnergyConnection> ENERGY_UP = ISidedEnergy.energySide("up", EnumFacing.UP);
    public static final PropertySidedEnum<EnergyConnection> ENERGY_NORTH = ISidedEnergy.energySide("north", EnumFacing.NORTH);
    public static final PropertySidedEnum<EnergyConnection> ENERGY_SOUTH = ISidedEnergy.energySide("south", EnumFacing.SOUTH);
    public static final PropertySidedEnum<EnergyConnection> ENERGY_WEST = ISidedEnergy.energySide("west", EnumFacing.WEST);
    public static final PropertySidedEnum<EnergyConnection> ENERGY_EAST = ISidedEnergy.energySide("east", EnumFacing.EAST);

    public static PropertySidedEnum<EnergyConnection> energySide(String name, EnumFacing facing) {
        return PropertySidedEnum.create((String)name, EnergyConnection.class, (Enum[])new EnergyConnection[]{EnergyConnection.IN, EnergyConnection.OUT, EnergyConnection.NON}, (EnumFacing)facing);
    }

    default public IBlockState getActualEnergyState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a(ENERGY_DOWN, (Comparable)((Object)this.getEnergyConnection(world, pos, EnumFacing.DOWN))).func_177226_a(ENERGY_UP, (Comparable)((Object)this.getEnergyConnection(world, pos, EnumFacing.UP))).func_177226_a(ENERGY_NORTH, (Comparable)((Object)this.getEnergyConnection(world, pos, EnumFacing.NORTH))).func_177226_a(ENERGY_SOUTH, (Comparable)((Object)this.getEnergyConnection(world, pos, EnumFacing.SOUTH))).func_177226_a(ENERGY_WEST, (Comparable)((Object)this.getEnergyConnection(world, pos, EnumFacing.WEST))).func_177226_a(ENERGY_EAST, (Comparable)((Object)this.getEnergyConnection(world, pos, EnumFacing.EAST)));
    }

    default public EnergyConnection getEnergyConnection(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof ITileEnergy ? ((ITileEnergy)tile).getEnergyConnection(facing) : EnergyConnection.NON;
    }

    default public BlockStateContainer createEnergyBlockState(Block block) {
        return new BlockStateContainer(block, new IProperty[]{ENERGY_DOWN, ENERGY_UP, ENERGY_NORTH, ENERGY_SOUTH, ENERGY_WEST, ENERGY_EAST});
    }
}

