/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.vanilla;

import nc.config.NCConfig;
import nc.enumm.MetaEnums;
import nc.init.NCBlocks;
import nc.init.NCItems;
import nc.util.OreDictHelper;
import nc.util.StringHelper;
import nc.worldgen.ore.OreGenerator;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class FurnaceRecipeHandler {
    public static void registerFurnaceRecipes() {
        String type;
        int i;
        for (i = 0; i < MetaEnums.OreType.values().length; ++i) {
            if (!OreGenerator.showOre(i)) continue;
            type = StringHelper.capitalize(MetaEnums.OreType.values()[i].func_176610_l());
            if (!NCConfig.ore_dict_raw_material_recipes) {
                GameRegistry.addSmelting((ItemStack)new ItemStack(NCBlocks.ore, 1, i), (ItemStack)OreDictHelper.getPrioritisedCraftingStack(new ItemStack(NCItems.ingot, 1, i), "ingot" + type), (float)0.5f);
                continue;
            }
            for (ItemStack ore : OreDictionary.getOres((String)("ore" + type))) {
                GameRegistry.addSmelting((ItemStack)ore, (ItemStack)OreDictHelper.getPrioritisedCraftingStack(new ItemStack(NCItems.ingot, 1, i), "ingot" + type), (float)0.5f);
            }
        }
        for (i = 0; i < MetaEnums.IngotType.values().length; ++i) {
            type = StringHelper.capitalize(MetaEnums.IngotType.values()[i].func_176610_l());
            if (!NCConfig.ore_dict_raw_material_recipes) {
                GameRegistry.addSmelting((ItemStack)new ItemStack(NCItems.dust, 1, i), (ItemStack)OreDictHelper.getPrioritisedCraftingStack(new ItemStack(NCItems.ingot, 1, i), "ingot" + type), (float)0.0f);
                continue;
            }
            for (ItemStack dust : OreDictionary.getOres((String)("dust" + type))) {
                GameRegistry.addSmelting((ItemStack)dust, (ItemStack)OreDictHelper.getPrioritisedCraftingStack(new ItemStack(NCItems.ingot, 1, i), "ingot" + type), (float)0.0f);
            }
        }
        for (i = 0; i < MetaEnums.IngotOxideType.values().length; ++i) {
            type = StringHelper.capitalize(MetaEnums.IngotOxideType.values()[i].func_176610_l()) + "Oxide";
            if (!NCConfig.ore_dict_raw_material_recipes) {
                GameRegistry.addSmelting((ItemStack)new ItemStack(NCItems.dust_oxide, 1, i), (ItemStack)OreDictHelper.getPrioritisedCraftingStack(new ItemStack(NCItems.ingot_oxide, 1, i), "ingot" + type), (float)0.0f);
                continue;
            }
            for (ItemStack dust : OreDictionary.getOres((String)("dust" + type))) {
                GameRegistry.addSmelting((ItemStack)dust, (ItemStack)OreDictHelper.getPrioritisedCraftingStack(new ItemStack(NCItems.ingot_oxide, 1, i), "ingot" + type), (float)0.0f);
            }
        }
        if (!NCConfig.ore_dict_raw_material_recipes) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(NCItems.ingot_oxide, 1, 3), (ItemStack)OreDictHelper.getPrioritisedCraftingStack(new ItemStack(NCItems.ingot_oxide, 1, 2), "ingotManganeseOxide"), (float)0.0f);
        } else {
            for (ItemStack ingot : OreDictionary.getOres((String)"ingotManganeseDioxide")) {
                GameRegistry.addSmelting((ItemStack)ingot, (ItemStack)OreDictHelper.getPrioritisedCraftingStack(new ItemStack(NCItems.ingot_oxide, 1, 2), "ingotManganeseOxide"), (float)0.0f);
            }
        }
        for (int i2 = 0; i2 < MetaEnums.IngotOxideType.values().length; ++i2) {
            if (i2 == 3) continue;
            type = StringHelper.capitalize(MetaEnums.IngotOxideType.values()[i2].func_176610_l());
            if (!NCConfig.ore_dict_raw_material_recipes) {
                GameRegistry.addSmelting((ItemStack)new ItemStack(NCItems.ingot_oxide, 1, i2), (ItemStack)OreDictHelper.getPrioritisedCraftingStack(new ItemStack(NCItems.ingot_oxide, 1, i2), "ingot" + type), (float)0.0f);
                continue;
            }
            for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + type + "Oxide"))) {
                GameRegistry.addSmelting((ItemStack)ingot, (ItemStack)OreDictHelper.getPrioritisedCraftingStack(new ItemStack(NCItems.ingot_oxide, 1, i2), "ingot" + type), (float)0.0f);
            }
        }
        GameRegistry.addSmelting((ItemStack)new ItemStack(NCItems.gem_dust, 1, 1), (ItemStack)OreDictHelper.getPrioritisedCraftingStack(new ItemStack(NCItems.dust_oxide, 1, 2), "dustManganeseOxide"), (float)0.0f);
        FurnaceRecipeHandler.oxideMaterialRecipes(NCItems.thorium, 2);
        FurnaceRecipeHandler.oxideMaterialRecipes(NCItems.uranium, 3);
        FurnaceRecipeHandler.oxideMaterialRecipes(NCItems.neptunium, 2);
        FurnaceRecipeHandler.oxideMaterialRecipes(NCItems.plutonium, 4);
        FurnaceRecipeHandler.oxideMaterialRecipes(NCItems.americium, 3);
        FurnaceRecipeHandler.oxideMaterialRecipes(NCItems.curium, 4);
        FurnaceRecipeHandler.oxideMaterialRecipes(NCItems.berkelium, 2);
        FurnaceRecipeHandler.oxideMaterialRecipes(NCItems.californium, 4);
        FurnaceRecipeHandler.oxideFuelRecipes(NCItems.fuel_thorium, NCItems.depleted_fuel_thorium, 1);
        FurnaceRecipeHandler.oxideFuelRecipes(NCItems.fuel_uranium, NCItems.depleted_fuel_uranium, 4);
        FurnaceRecipeHandler.oxideFuelRecipes(NCItems.fuel_neptunium, NCItems.depleted_fuel_neptunium, 2);
        FurnaceRecipeHandler.oxideFuelRecipes(NCItems.fuel_plutonium, NCItems.depleted_fuel_plutonium, 4);
        FurnaceRecipeHandler.oxideFuelRecipes(NCItems.fuel_americium, NCItems.depleted_fuel_americium, 2);
        FurnaceRecipeHandler.oxideFuelRecipes(NCItems.fuel_curium, NCItems.depleted_fuel_curium, 6);
        FurnaceRecipeHandler.oxideFuelRecipes(NCItems.fuel_berkelium, NCItems.depleted_fuel_berkelium, 2);
        FurnaceRecipeHandler.oxideFuelRecipes(NCItems.fuel_californium, NCItems.depleted_fuel_californium, 4);
        GameRegistry.addSmelting((ItemStack)new ItemStack(Items.field_151100_aR, 1, 3), (ItemStack)new ItemStack(NCItems.roasted_cocoa_beans, 1), (float)0.0f);
    }

    public static void oxideFuelRecipes(Item fuelType, Item depletedFuelType, int noFuelTypes) {
        for (int i = 0; i < noFuelTypes; ++i) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(fuelType, 1, 1 + 2 * i), (ItemStack)new ItemStack(fuelType, 1, 2 * i), (float)0.0f);
            GameRegistry.addSmelting((ItemStack)new ItemStack(depletedFuelType, 1, 1 + 2 * i), (ItemStack)new ItemStack(depletedFuelType, 1, 2 * i), (float)0.0f);
        }
    }

    public static void oxideMaterialRecipes(Item material, int noTypes) {
        for (int i = 0; i < 2 * noTypes; ++i) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(material, 1, 1 + 2 * i), (ItemStack)new ItemStack(material, 1, 2 * i), (float)0.0f);
        }
    }
}

