/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.heat;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class HeatBuffer
implements INBTSerializable<NBTTagCompound> {
    public long heatStored;
    public long heatCapacity;

    public HeatBuffer(long capacity) {
        this.heatCapacity = capacity;
    }

    public boolean isFull() {
        return this.heatStored >= this.heatCapacity;
    }

    public long removeHeat(long heat, boolean simulated) {
        long heatRemoved = Math.min(this.heatStored, heat);
        if (!simulated) {
            this.heatStored -= heatRemoved;
        }
        return heatRemoved;
    }

    public long addHeat(long heat, boolean simulated) {
        long heatAdded = Math.min(this.heatCapacity - this.heatStored, heat);
        if (!simulated) {
            this.heatStored += heatAdded;
        }
        return heatAdded;
    }

    public long getHeatStored() {
        return Math.min(this.heatStored, Long.MAX_VALUE);
    }

    public long getHeatCapacity() {
        return Math.min(this.heatCapacity, Long.MAX_VALUE);
    }

    public void changeHeatStored(long heat) {
        this.heatStored += heat;
        if (this.heatStored > this.heatCapacity) {
            this.heatStored = this.heatCapacity;
        } else if (this.heatStored < 0L) {
            this.heatStored = 0L;
        }
    }

    public void setHeatStored(long heat) {
        this.heatStored = heat;
        if (this.heatStored > this.heatCapacity) {
            this.heatStored = this.heatCapacity;
        } else if (this.heatStored < 0L) {
            this.heatStored = 0L;
        }
    }

    public void setHeatCapacity(long newCapacity) {
        if (newCapacity == this.heatCapacity || newCapacity <= 0L) {
            return;
        }
        this.heatCapacity = newCapacity;
        if (newCapacity < this.heatStored) {
            this.setHeatStored(newCapacity);
        }
    }

    public void mergeHeatBuffers(HeatBuffer other) {
        this.setHeatStored(this.heatStored + other.heatStored);
        this.setHeatCapacity(this.heatCapacity + other.heatCapacity);
    }

    public NBTTagCompound serializeNBT() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.readAll(nbt);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.heatStored < 0L) {
            this.heatStored = 0L;
        }
        nbt.func_74772_a("Heat", this.heatStored);
        nbt.func_74772_a("Capacity", this.heatCapacity);
        return nbt;
    }

    public final NBTTagCompound writeAll(NBTTagCompound nbt) {
        NBTTagCompound heatTag = new NBTTagCompound();
        this.writeToNBT(heatTag);
        nbt.func_74782_a("heatStorage", (NBTBase)heatTag);
        return nbt;
    }

    public HeatBuffer readFromNBT(NBTTagCompound nbt) {
        this.heatStored = nbt.func_74763_f("Heat");
        this.heatCapacity = nbt.func_74763_f("Capacity");
        if (this.heatStored > this.heatCapacity) {
            this.heatStored = this.heatCapacity;
        }
        return this;
    }

    public final void readAll(NBTTagCompound nbt) {
        if (nbt.func_74764_b("heatStorage")) {
            this.readFromNBT(nbt.func_74775_l("heatStorage"));
        }
    }
}

