/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core;

import chikachi.discord.core.MinecraftFormattingCodes;
import chikachi.discord.core.Patterns;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.LongStream;

public class CoreUtils {
    public static void addPatterns() {
        Patterns.clearCustomPatterns();
        Patterns.addMinecraftFormattingUnifyPattern(Patterns.fakeMinecraftCodePattern, new Patterns.ReplacementCallback(){

            @Override
            public String pre(String text) {
                return text;
            }

            @Override
            public String replace(ArrayList<String> groups) {
                MinecraftFormattingCodes minecraftFormattingCode = MinecraftFormattingCodes.getByCode(groups.get(1).charAt(0));
                if (minecraftFormattingCode != null) {
                    return minecraftFormattingCode.toString();
                }
                return groups.get(0);
            }

            @Override
            public String post(String text) {
                return text;
            }
        });
        Patterns.addDiscordToMinecraftFormattingPattern(Pattern.compile("(?i)(\\*\\*|\\*|__|_|~~|`|```)"), new Patterns.ReplacementCallback(){
            private boolean bold = false;
            private boolean italic = false;
            private String lastItalic = "";
            private boolean underline = false;
            private boolean strikethrough = false;

            @Override
            public String pre(String text) {
                return text;
            }

            @Override
            public String replace(ArrayList<String> groups) {
                String modifier;
                switch (modifier = groups.get(0)) {
                    case "**": {
                        this.bold = !this.bold;
                        modifier = this.bold ? MinecraftFormattingCodes.BOLD.toString() : this.resetString();
                        break;
                    }
                    case "*": 
                    case "_": {
                        if (this.italic && !modifier.equals(this.lastItalic)) {
                            return modifier;
                        }
                        this.lastItalic = modifier;
                        this.italic = !this.italic;
                        modifier = this.italic ? MinecraftFormattingCodes.ITALIC.toString() : this.resetString();
                        break;
                    }
                    case "__": {
                        this.underline = !this.underline;
                        modifier = this.underline ? MinecraftFormattingCodes.UNDERLINE.toString() : this.resetString();
                        break;
                    }
                    case "~~": {
                        this.strikethrough = !this.strikethrough;
                        modifier = this.strikethrough ? MinecraftFormattingCodes.STRIKETHROUGH.toString() : this.resetString();
                    }
                }
                return modifier;
            }

            private String resetString() {
                String text = MinecraftFormattingCodes.RESET.toString();
                if (this.strikethrough) {
                    text = text + MinecraftFormattingCodes.STRIKETHROUGH.toString();
                }
                if (this.underline) {
                    text = text + MinecraftFormattingCodes.UNDERLINE.toString();
                }
                if (this.italic) {
                    text = text + MinecraftFormattingCodes.ITALIC.toString();
                }
                if (this.bold) {
                    text = text + MinecraftFormattingCodes.BOLD.toString();
                }
                return text;
            }

            @Override
            public String post(String text) {
                if (this.strikethrough) {
                    int lastStrikethrough = text.lastIndexOf(MinecraftFormattingCodes.STRIKETHROUGH.toString());
                    text = text.substring(0, lastStrikethrough) + "~~" + text.substring(lastStrikethrough + 2);
                    this.strikethrough = false;
                }
                if (this.underline) {
                    int lastUnderline = text.lastIndexOf(MinecraftFormattingCodes.UNDERLINE.toString());
                    text = text.substring(0, lastUnderline) + "__" + text.substring(lastUnderline + 2);
                    this.underline = false;
                }
                if (this.italic) {
                    int lastItalic = text.lastIndexOf(MinecraftFormattingCodes.ITALIC.toString());
                    text = text.substring(0, lastItalic) + this.lastItalic + text.substring(lastItalic + 2);
                    this.italic = false;
                }
                if (this.bold) {
                    int lastBold = text.lastIndexOf(MinecraftFormattingCodes.BOLD.toString());
                    text = text.substring(0, lastBold) + "**" + text.substring(lastBold + 2);
                    this.bold = false;
                }
                text = Pattern.compile("(?i)\u00a7r(\u00a7([0-9A-FK-OR]))+\u00a7r").matcher(text).replaceAll(MinecraftFormattingCodes.RESET.toString());
                return text;
            }
        });
        Patterns.addMinecraftToDiscordFormattingPattern(Patterns.minecraftCodePattern, new Patterns.ReplacementCallback(){
            private boolean bold = false;
            private boolean italic = false;
            private boolean underline = false;
            private boolean strikethrough = false;

            @Override
            public String pre(String text) {
                return text;
            }

            @Override
            public String replace(ArrayList<String> groups) {
                String modifier = groups.get(0);
                if (modifier.equalsIgnoreCase(MinecraftFormattingCodes.BOLD.toString())) {
                    this.bold = true;
                    modifier = "**";
                } else if (modifier.equalsIgnoreCase(MinecraftFormattingCodes.ITALIC.toString())) {
                    this.italic = true;
                    modifier = "*";
                } else if (modifier.equalsIgnoreCase(MinecraftFormattingCodes.UNDERLINE.toString())) {
                    this.underline = true;
                    modifier = "__";
                } else if (modifier.equalsIgnoreCase(MinecraftFormattingCodes.STRIKETHROUGH.toString())) {
                    this.strikethrough = true;
                    modifier = "~~";
                } else if (modifier.equalsIgnoreCase(MinecraftFormattingCodes.RESET.toString())) {
                    modifier = "";
                    if (this.bold) {
                        this.bold = false;
                        modifier = modifier + "**";
                    }
                    if (this.italic) {
                        this.italic = false;
                        modifier = modifier + "*";
                    }
                    if (this.underline) {
                        this.underline = false;
                        modifier = modifier + "__";
                    }
                    if (this.strikethrough) {
                        this.strikethrough = false;
                        modifier = modifier + "~~";
                    }
                } else {
                    modifier = "";
                }
                return modifier;
            }

            @Override
            public String post(String text) {
                if (this.strikethrough) {
                    text = text + "~~";
                    this.strikethrough = false;
                }
                if (this.underline) {
                    text = text + "__";
                    this.underline = false;
                }
                if (this.italic) {
                    text = text + "*";
                    this.italic = false;
                }
                if (this.bold) {
                    text = text + "**";
                    this.bold = false;
                }
                return text.replaceAll("\\*\\*\\*\\*\\*", "*");
            }
        });
    }

    public static String replace(Map<String, String> replaceMap, String text) {
        Object[] words = text.split(" ");
        Set<Map.Entry<String, String>> entries = replaceMap.entrySet();
        int j = words.length;
        for (int i = 0; i < j; ++i) {
            String word = words[i];
            for (Map.Entry<String, String> entry : entries) {
                if (!word.equals(entry.getKey())) continue;
                words[i] = entry.getValue();
            }
        }
        return Joiner.on((String)" ").join(words);
    }

    public static String tpsToColorString(double tps, boolean isDiscord) {
        if (19.0 <= tps) {
            return isDiscord ? "+ " : MinecraftFormattingCodes.GREEN.toString();
        }
        if (15.0 <= tps) {
            return isDiscord ? "! " : MinecraftFormattingCodes.YELLOW.toString();
        }
        return isDiscord ? "- " : MinecraftFormattingCodes.RED.toString();
    }

    public static String padLeft(String s, int n) {
        int spaces = n - s.length();
        if (spaces < 1) {
            return s;
        }
        String padding = new String(new char[spaces]).replace("\u0000", " ");
        return padding + s;
    }

    public static String padRight(String s, int n) {
        int spaces = n - s.length();
        if (spaces < 1) {
            return s;
        }
        String padding = new String(new char[spaces]).replace("\u0000", " ");
        return s + padding;
    }

    public static Integer getMinValue(Set<Integer> values) {
        if (values.size() == 0) {
            return 0;
        }
        Integer value = null;
        for (Integer val : values) {
            if (value == null) {
                value = val;
                continue;
            }
            if (val >= value) continue;
            value = val;
        }
        return value;
    }

    public static Integer getMaxValue(Set<Integer> values) {
        if (values.size() == 0) {
            return 0;
        }
        Integer value = null;
        for (Integer val : values) {
            if (value == null) {
                value = val;
                continue;
            }
            if (value >= val) continue;
            value = val;
        }
        return value;
    }

    public static Integer getMinLength(Collection<String> strings) {
        if (strings.size() == 0) {
            return 0;
        }
        Integer length = null;
        for (String string : strings) {
            int stringLength = string.length();
            if (length == null) {
                length = stringLength;
                continue;
            }
            if (stringLength >= length) continue;
            length = stringLength;
        }
        return length;
    }

    public static Integer getMaxLength(Collection<String> strings) {
        if (strings.size() == 0) {
            return 0;
        }
        Integer length = null;
        for (String string : strings) {
            int stringLength = string.length();
            if (length == null) {
                length = stringLength;
                continue;
            }
            if (length >= stringLength) continue;
            length = stringLength;
        }
        return length;
    }

    public static long mean(long[] values) {
        return LongStream.of(values).sum() / (long)values.length;
    }

    public static String getAvatarUrl(String minecraftUsername) {
        return String.format("https://minotar.net/helm/%s/128.png", minecraftUsername);
    }
}

