/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core;

import chikachi.discord.core.DiscordIntegrationLogger;
import chikachi.discord.core.Message;
import chikachi.discord.core.WebhookMessage;
import chikachi.discord.core.config.Configuration;
import chikachi.discord.core.config.minecraft.MinecraftConfig;
import chikachi.discord.core.config.types.MessageConfig;
import chikachi.discord.repack.net.dv8tion.jda.core.AccountType;
import chikachi.discord.repack.net.dv8tion.jda.core.JDA;
import chikachi.discord.repack.net.dv8tion.jda.core.JDABuilder;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.SelfUser;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.TextChannel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.User;
import chikachi.discord.repack.net.dv8tion.jda.core.events.ReadyEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.hooks.EventListener;
import chikachi.discord.repack.net.dv8tion.jda.core.hooks.ListenerAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.login.LoginException;

public class DiscordClient
extends ListenerAdapter {
    private static DiscordClient instance;
    private ArrayList<EventListener> eventListeners = new ArrayList();
    private boolean isReady = false;
    private JDA jda;

    private DiscordClient() {
    }

    public static DiscordClient getInstance() {
        if (instance == null) {
            instance = new DiscordClient();
        }
        return instance;
    }

    @Override
    public void onReady(ReadyEvent event) {
        DiscordIntegrationLogger.Log("Logged in as " + this.getSelf().getName());
        this.isReady = true;
        MinecraftConfig minecraftConfig = Configuration.getConfig().minecraft;
        DiscordClient.getInstance().broadcast(new Message(minecraftConfig.dimensions.generic.messages.serverStart), minecraftConfig.dimensions.generic.relayServerStart.getChannels(minecraftConfig.dimensions.generic.discordChannel));
        this.isReady = false;
    }

    public void connect() {
        this.connect(false);
    }

    private void connect(boolean noMessage) {
        if (this.jda != null) {
            if (noMessage) {
                DiscordIntegrationLogger.Log("Is already connected", true);
            }
            return;
        }
        String token = Configuration.getConfig().discord.token;
        if (token == null || token.isEmpty()) {
            if (noMessage) {
                DiscordIntegrationLogger.Log("Missing token", true);
            }
            return;
        }
        try {
            JDABuilder builder = new JDABuilder(AccountType.BOT).setToken(token).setAudioEnabled(false).setBulkDeleteSplittingEnabled(false).addEventListener(this);
            for (EventListener eventListener : this.eventListeners) {
                builder.addEventListener(eventListener);
            }
            this.jda = builder.buildAsync();
        }
        catch (LoginException e) {
            DiscordIntegrationLogger.Log(String.format("Failed to connect to Discord: %s", e.getMessage()), true);
        }
        catch (Exception e) {
            DiscordIntegrationLogger.Log("Failed to connect to Discord", true);
            e.printStackTrace();
        }
    }

    public void addEventListener(EventListener eventListener) {
        if (eventListener != null) {
            if (this.eventListeners.contains(eventListener)) {
                return;
            }
            this.eventListeners.add(eventListener);
            if (this.jda != null) {
                this.jda.addEventListener(eventListener);
            }
        }
    }

    public void removeEventListener(EventListener eventListener) {
        if (eventListener != null) {
            if (!this.eventListeners.contains(eventListener)) {
                return;
            }
            this.eventListeners.remove(eventListener);
            if (this.jda != null) {
                this.jda.removeEventListener(eventListener);
            }
        }
    }

    public boolean isConnected() {
        return this.jda != null && (this.isReady || this.jda.getStatus() == JDA.Status.CONNECTED);
    }

    public void disconnect() {
        this.disconnect(false);
    }

    void disconnect(boolean noMessage) {
        if (this.jda == null) {
            if (!noMessage) {
                DiscordIntegrationLogger.Log("Is already disconnected", true);
            }
            return;
        }
        this.jda.shutdown();
        if (!noMessage) {
            DiscordIntegrationLogger.Log("Disconnected from Discord", true);
        }
        this.jda = null;
    }

    public JDA getJda() {
        return this.jda;
    }

    public SelfUser getSelf() {
        if (this.jda == null) {
            return null;
        }
        return this.jda.getSelfUser();
    }

    public User getUser(long userId) {
        if (this.jda == null) {
            return null;
        }
        return this.jda.getUserById(userId);
    }

    void broadcast(MessageConfig message, List<Long> channels) {
        this.broadcast(new Message(message), channels);
    }

    public void broadcast(Message message, Long ... channels) {
        this.broadcast(message, Arrays.asList(channels));
    }

    public void broadcast(Message message, List<Long> channels) {
        if (channels == null || channels.size() == 0 || this.jda == null || !this.isReady && this.jda.getStatus() != JDA.Status.CONNECTED) {
            return;
        }
        for (Long channelId : channels) {
            WebhookMessage webhookMessage;
            TextChannel channel = this.jda.getTextChannelById(channelId);
            if (channel == null) {
                DiscordIntegrationLogger.Log(String.format("Could not find channel %s", channelId));
                continue;
            }
            if (!channel.canTalk()) {
                DiscordIntegrationLogger.Log(String.format("Missing permission to write in channel %s (%s)", channel.getName(), channelId));
                continue;
            }
            if (Configuration.getConfig().discord.channels.channels.containsKey(channelId) && Configuration.getConfig().discord.channels.channels.get((Object)channelId).webhook.trim().length() > 0 && (webhookMessage = message.toWebhook(channel)).queue(this.jda, channelId)) continue;
            String text = message.getFormattedTextDiscord(channel);
            if (text.length() > 2000) {
                text = text.substring(0, 1997) + "...";
            }
            channel.sendMessage(text).queue();
        }
    }
}

