/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core;

import chikachi.discord.core.CoreConstants;
import chikachi.discord.core.CoreUtils;
import chikachi.discord.core.Patterns;
import chikachi.discord.core.WebhookMessage;
import chikachi.discord.core.config.Configuration;
import chikachi.discord.core.config.types.MessageConfig;
import chikachi.discord.repack.com.vdurmont.emoji.EmojiParser;
import chikachi.discord.repack.net.dv8tion.jda.core.Permission;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Channel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Member;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Role;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.TextChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;

public class Message {
    private String author = null;
    private String avatarUrl = null;
    private String prefix = null;
    private MessageConfig message = null;
    private HashMap<String, String> arguments = null;
    private boolean parsing = true;

    public Message() {
    }

    public Message(MessageConfig message) {
        this(message, new HashMap<String, String>());
    }

    public Message(MessageConfig message, HashMap<String, String> arguments) {
        this(null, message, arguments);
    }

    public Message(String author, MessageConfig message) {
        this(author, message, new HashMap<String, String>());
    }

    public Message(String author, MessageConfig message, HashMap<String, String> arguments) {
        this(author, null, message, arguments);
    }

    public Message(String author, String avatarUrl, MessageConfig message) {
        this(author, avatarUrl, message, new HashMap<String, String>());
    }

    public Message(String author, String avatarUrl, MessageConfig message, HashMap<String, String> arguments) {
        this.author = author;
        this.avatarUrl = avatarUrl;
        this.message = message;
        this.arguments = arguments == null ? new HashMap() : arguments;
        this.arguments.put("USER", this.getAuthor());
    }

    WebhookMessage toWebhook(TextChannel channel) {
        return new WebhookMessage(this.formatText(this.message.webhook, channel), this.author, this.avatarUrl);
    }

    public Message setMessage(MessageConfig message) {
        this.message = message;
        return this;
    }

    public Message setAvatarUrl(String avatar_url) {
        this.avatarUrl = avatar_url;
        return this;
    }

    public Message setArguments(HashMap<String, String> arguments) {
        this.arguments = arguments;
        return this;
    }

    public Message setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    private String getAuthor() {
        return this.author;
    }

    public Message setAuthor(String author) {
        this.author = author;
        return this;
    }

    private boolean isParsing() {
        return this.parsing;
    }

    public Message setParsing(boolean parsing) {
        this.parsing = parsing;
        return this;
    }

    private String formatText(String text, Channel channel) {
        return this.formatText(text, channel, true);
    }

    private String formatText(String text, Channel channel, boolean isDiscord) {
        String message = text;
        if (this.arguments == null) {
            this.arguments = new HashMap();
        }
        this.arguments.put("USER", this.getAuthor());
        for (Map.Entry<String, String> entry : this.arguments.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            message = message.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        if (channel != null && message.contains("@")) {
            Matcher m = Patterns.tagPattern.matcher(message);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                Optional<Role> theRole;
                Optional<Member> theMember;
                String name = m.group(2);
                String hash = m.group(3);
                if (name.equalsIgnoreCase("everyone") && hash == null) {
                    if (Configuration.getConfig().minecraft.dimensions.generic.canMentionEveryone) {
                        return "@everyone";
                    }
                    return name;
                }
                if (name.equalsIgnoreCase("here") && hash == null) {
                    if (Configuration.getConfig().minecraft.dimensions.generic.canMentionHere) {
                        return "@here";
                    }
                    return name;
                }
                if (Configuration.getConfig().minecraft.dimensions.generic.canMentionUsers && (theMember = channel.getGuild().getMembersByName(name, true).stream().filter(member -> hash == null || member.getUser().getDiscriminator().equalsIgnoreCase(hash)).filter(member -> member.hasPermission(channel, Permission.MESSAGE_READ)).findAny()).isPresent()) {
                    m.appendReplacement(sb, theMember.get().getAsMention());
                    continue;
                }
                if (Configuration.getConfig().minecraft.dimensions.generic.canMentionRoles && (theRole = channel.getGuild().getRolesByName(name, true).stream().filter(Role::isMentionable).filter(role -> role.hasPermission(channel, Permission.MESSAGE_READ)).findAny()).isPresent()) {
                    m.appendReplacement(sb, theRole.get().getAsMention());
                    continue;
                }
                m.appendReplacement(sb, name);
            }
            m.appendTail(sb);
            message = sb.toString();
        }
        if (this.isParsing()) {
            if (isDiscord) {
                message = CoreUtils.replace(CoreConstants.minecraftToDiscordEmotes, message);
                message = EmojiParser.parseToUnicode(message);
                message = Patterns.minecraftToDiscord(message);
            } else {
                message = EmojiParser.parseToAliases(message, EmojiParser.FitzpatrickAction.REMOVE);
                message = CoreUtils.replace(CoreConstants.discordToMinecraftEmotes, message);
                message = Patterns.discordToMinecraft(message);
            }
        }
        return String.format("%s%s", this.prefix != null && this.prefix.trim().length() > 0 ? this.prefix.trim() + " " : "", message);
    }

    private String getUnformattedText() {
        return this.message != null ? this.message.normal : "";
    }

    String getFormattedTextDiscord(Channel channel) {
        return this.formatText(this.getUnformattedText(), channel, true);
    }

    public String getFormattedTextMinecraft() {
        return this.formatText(this.getUnformattedText(), null, false);
    }
}

