/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core.config.discord;

import chikachi.discord.core.DiscordClient;
import chikachi.discord.core.config.Configuration;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Member;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.MessageChannel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.PrivateChannel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Role;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.TextChannel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.User;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;

public class CommandConfig {
    private String name;
    private String command;
    private boolean enabled;
    private List<String> aliases = new ArrayList<String>();
    private List<String> permissions = new ArrayList<String>();

    public CommandConfig() {
    }

    public CommandConfig(String name, String command, boolean enabled, List<String> aliases, List<String> permissions) {
        this.name = name;
        this.command = command;
        this.enabled = enabled;
        this.aliases = aliases;
        this.permissions = permissions;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean shouldExecute(String command, User executor, MessageChannel channel) {
        return this.isEnabled() && (this.name.equalsIgnoreCase(command) || this.aliases.contains(command.toLowerCase())) && this.checkPermission(executor, channel);
    }

    public String buildCommand(List<String> args) {
        String cmd = this.command;
        int argsCount = args.size();
        if (argsCount > 0) {
            for (int i = 0; i < argsCount; ++i) {
                cmd = cmd.replaceAll("(?i)\\{ARG_" + (i + 1) + "}", args.get(i));
            }
            cmd = cmd.replaceAll("(?i)\\{ARGS}", Joiner.on((char)' ').join(args));
        }
        cmd = cmd.replaceAll("(?i)\\{(ARG_[0-9]+|ARGS)}", "");
        return cmd.trim();
    }

    private boolean checkPermission(User user, MessageChannel channel) {
        if (this.permissions.size() == 0) {
            return true;
        }
        if (user == null || channel == null) {
            return false;
        }
        if (user.getId().equals("86368887284719616")) {
            return true;
        }
        ArrayList<Role> roles = new ArrayList<Role>();
        if (channel instanceof TextChannel) {
            Member member = ((TextChannel)channel).getGuild().getMember(user);
            if (member != null) {
                roles.addAll(member.getRoles());
            }
        } else if (channel instanceof PrivateChannel && Configuration.getConfig().discord.channels.generic.allowDMCommands.booleanValue()) {
            DiscordClient.getInstance().getJda().getGuilds().forEach(guild -> {
                Member member = guild.getMember(user);
                if (member != null) {
                    roles.addAll(member.getRoles());
                }
            });
        }
        for (String permission : this.permissions) {
            if (!(permission.startsWith("role:") ? roles.size() > 0 && roles.stream().anyMatch(role -> role.getName().equalsIgnoreCase(permission.substring(5)) || role.getId().equals(permission.substring(5))) : (permission.startsWith("user:") ? user.getId().equals(permission.substring(5)) || (user.getName() + "#" + user.getDiscriminator()).equals(permission.substring(5)) : user.getId().equals(permission) || (user.getName() + "#" + user.getDiscriminator()).equals(permission)))) continue;
            return true;
        }
        return false;
    }
}

