/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core.config.types;

import java.util.ArrayList;

public class ChannelConfigType {
    private ArrayList<Long> channels;
    private boolean isDefault;
    private boolean isDisabled;

    public ChannelConfigType() {
        this(false);
    }

    public ChannelConfigType(boolean isDisabled) {
        this(!isDisabled, isDisabled);
    }

    public ChannelConfigType(boolean isDefault, boolean isDisabled) {
        this(new ArrayList<Long>(), isDefault, isDisabled);
    }

    public ChannelConfigType(ArrayList<Long> channels, boolean isDefault, boolean isDisabled) {
        this.channels = channels;
        this.isDefault = isDefault;
        this.isDisabled = isDisabled;
    }

    public ChannelConfigType addChannel(Long channel) {
        this.channels.add(channel);
        return this;
    }

    public ArrayList<Long> getChannels() {
        return this.isDisabled() ? null : (this.isDefault() ? null : this.channels);
    }

    public ChannelConfigType setChannels(ArrayList<Long> channels) {
        if (channels != null) {
            this.channels = channels;
        }
        return this;
    }

    public ArrayList<Long> getChannels(ArrayList<Long> defaultChannels) {
        return this.isDisabled() ? null : (this.isDefault() ? defaultChannels : this.channels);
    }

    public ArrayList<Long> getChannels(ChannelConfigType defaultChannels) {
        return this.getChannels(defaultChannels.channels);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public ChannelConfigType setDefault(boolean aDefault) {
        this.isDefault = aDefault;
        return this;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public ChannelConfigType setDisabled(boolean disabled) {
        this.isDisabled = disabled;
        return this;
    }
}

