/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.core.config.types;

import java.util.ArrayList;

public class DimensionConfigType {
    private ArrayList<Integer> dimensions;
    private boolean isDefault;
    private boolean isDisabled;

    public DimensionConfigType() {
        this(false);
    }

    public DimensionConfigType(boolean isDisabled) {
        this(!isDisabled, isDisabled);
    }

    public DimensionConfigType(boolean isDefault, boolean isDisabled) {
        this(new ArrayList<Integer>(), isDefault, isDisabled);
    }

    public DimensionConfigType(ArrayList<Integer> dimensions, boolean isDefault, boolean isDisabled) {
        this.dimensions = dimensions;
        this.isDefault = isDefault;
        this.isDisabled = isDisabled;
    }

    public DimensionConfigType addDimension(int dimension) {
        this.dimensions.add(dimension);
        return this;
    }

    public ArrayList<Integer> getDimensions() {
        return this.isDisabled() ? null : (this.isDefault() ? new ArrayList<Integer>() : this.dimensions);
    }

    public DimensionConfigType setDimensions(ArrayList<Integer> dimensions) {
        if (dimensions != null) {
            this.dimensions = dimensions;
        }
        return this;
    }

    public ArrayList<Integer> getDimensions(ArrayList<Integer> defaultDimensions) {
        return this.isDisabled() ? null : (this.isDefault() ? defaultDimensions : this.dimensions);
    }

    public ArrayList<Integer> getDimensions(DimensionConfigType defaultDimensions) {
        return this.getDimensions(defaultDimensions.dimensions);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public DimensionConfigType setDefault(boolean aDefault) {
        this.isDefault = aDefault;
        return this;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public DimensionConfigType setDisabled(boolean disabled) {
        this.isDisabled = disabled;
        return this;
    }
}

