/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.integration;

import chikachi.discord.core.DiscordClient;
import chikachi.discord.core.DiscordIntegrationLogger;
import chikachi.discord.core.Message;
import chikachi.discord.core.config.ConfigWrapper;
import chikachi.discord.core.config.Configuration;
import chikachi.discord.core.config.discord.DiscordConfig;
import chikachi.discord.core.config.minecraft.MinecraftGenericConfig;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.ChannelType;
import chikachi.discord.repack.net.dv8tion.jda.core.events.Event;
import chikachi.discord.repack.net.dv8tion.jda.core.events.message.MessageReceivedEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.hooks.EventListener;
import java.util.HashMap;
import net.minecraftforge.fml.common.Optional;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;

@Optional.Interface(iface="org.dynmap.DynmapCommonAPIListener", modid="dynmap")
public class DynmapIntegration
extends DynmapCommonAPIListener
implements EventListener {
    private DynmapCommonAPI dynmapCommonAPI;

    public DynmapIntegration() {
        DynmapCommonAPIListener.register((DynmapCommonAPIListener)this);
        DiscordIntegrationLogger.Log("Listening to Dynmap");
    }

    @Optional.Method(modid="dynmap")
    public void apiEnabled(DynmapCommonAPI dynmapCommonAPI) {
        DiscordIntegrationLogger.Log("Dynmap API enabled");
        this.dynmapCommonAPI = dynmapCommonAPI;
        DiscordClient.getInstance().addEventListener(this);
    }

    @Optional.Method(modid="dynmap")
    public void apiDisabled(DynmapCommonAPI api) {
        super.apiDisabled(api);
        DiscordIntegrationLogger.Log("Dynmap API disabled");
        this.dynmapCommonAPI = null;
        DiscordClient.getInstance().removeEventListener(this);
    }

    @Optional.Method(modid="dynmap")
    public boolean webChatEvent(String source, String name, String message) {
        if (Configuration.getConfig().minecraft.integrations.dynmapEnabled) {
            MinecraftGenericConfig genericConfig = Configuration.getConfig().minecraft.dimensions.generic;
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("MESSAGE", message);
            DiscordClient.getInstance().broadcast(new Message().setAuthor("[Dynmap]" + (name != null && name.trim().length() > 0 ? " " + name : "")).setMessage(genericConfig.messages.chatMessage).setArguments(arguments), genericConfig.relayChat.getChannels(genericConfig.discordChannel));
        }
        return true;
    }

    @Override
    public void onEvent(Event event) {
        if (this.dynmapCommonAPI == null) {
            return;
        }
        if (event instanceof MessageReceivedEvent) {
            MessageReceivedEvent messageReceivedEvent = (MessageReceivedEvent)event;
            ConfigWrapper config = Configuration.getConfig();
            DiscordConfig discordConfig = config.discord;
            if (discordConfig.ignoresBots && messageReceivedEvent.getAuthor().isBot()) {
                return;
            }
            if (messageReceivedEvent.getAuthor().getId().equals(DiscordClient.getInstance().getSelf().getId())) {
                return;
            }
            if (discordConfig.isIgnoringUser(messageReceivedEvent.getAuthor())) {
                return;
            }
            String content = messageReceivedEvent.getMessage().getContentDisplay().trim();
            if (messageReceivedEvent.getChannelType() == ChannelType.TEXT) {
                Long channelId = messageReceivedEvent.getChannel().getIdLong();
                boolean stripMinecraftCodes = discordConfig.channels.generic.stripMinecraftCodes;
                if (!discordConfig.channels.channels.containsKey(channelId)) {
                    return;
                }
                this.dynmapCommonAPI.sendBroadcastToWeb(messageReceivedEvent.getAuthor().getName(), messageReceivedEvent.getMessage().getContentStripped());
            }
        }
    }
}

