/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.bot.utils.cache.impl;

import chikachi.discord.repack.net.dv8tion.jda.bot.utils.cache.ShardCacheView;
import chikachi.discord.repack.net.dv8tion.jda.core.JDA;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.Checks;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.cache.CacheView;
import gnu.trove.impl.sync.TSynchronizedIntObjectMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class ShardCacheViewImpl
implements ShardCacheView {
    protected final TIntObjectMap<JDA> elements;

    public ShardCacheViewImpl() {
        this.elements = new TSynchronizedIntObjectMap<JDA>(new TIntObjectHashMap(), new Object());
    }

    public ShardCacheViewImpl(int initialCapacity) {
        this.elements = new TSynchronizedIntObjectMap<JDA>(new TIntObjectHashMap(initialCapacity), new Object());
    }

    public void clear() {
        this.elements.clear();
    }

    public TIntObjectMap<JDA> getMap() {
        return this.elements;
    }

    @Override
    public List<JDA> asList() {
        return Collections.unmodifiableList(new ArrayList<JDA>(this.elements.valueCollection()));
    }

    @Override
    public Set<JDA> asSet() {
        return Collections.unmodifiableSet(new HashSet<JDA>(this.elements.valueCollection()));
    }

    @Override
    public long size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public List<JDA> getElementsByName(String name, boolean ignoreCase) {
        Checks.notEmpty(name, "Name");
        if (this.elements.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<JDA> list = new LinkedList<JDA>();
        for (JDA elem : this.elements.valueCollection()) {
            String elementName = elem.getShardInfo().getShardString();
            if (elementName == null) continue;
            if (ignoreCase) {
                if (!elementName.equalsIgnoreCase(name)) continue;
                list.add(elem);
                continue;
            }
            if (!elementName.equals(name)) continue;
            list.add(elem);
        }
        return list;
    }

    @Override
    public Stream<JDA> stream() {
        return this.elements.valueCollection().stream();
    }

    @Override
    public Stream<JDA> parallelStream() {
        return this.elements.valueCollection().parallelStream();
    }

    @Override
    @Nonnull
    public Iterator<JDA> iterator() {
        return this.asList().iterator();
    }

    @Override
    public JDA getElementById(int id) {
        return this.elements.get(id);
    }

    public static class UnifiedShardCacheViewImpl
    implements ShardCacheView {
        protected final Supplier<Stream<ShardCacheView>> generator;

        public UnifiedShardCacheViewImpl(Supplier<Stream<ShardCacheView>> generator) {
            this.generator = generator;
        }

        @Override
        public long size() {
            return this.generator.get().distinct().mapToLong(CacheView::size).sum();
        }

        @Override
        public boolean isEmpty() {
            return this.generator.get().allMatch(CacheView::isEmpty);
        }

        @Override
        public List<JDA> asList() {
            ArrayList list = new ArrayList();
            this.stream().forEach(list::add);
            return Collections.unmodifiableList(list);
        }

        @Override
        public Set<JDA> asSet() {
            HashSet set = new HashSet();
            this.generator.get().forEach(view -> view.forEach(set::add));
            return Collections.unmodifiableSet(set);
        }

        @Override
        public List<JDA> getElementsByName(String name, boolean ignoreCase) {
            return Collections.unmodifiableList(this.generator.get().distinct().flatMap(view -> view.getElementsByName(name, ignoreCase).stream()).collect(Collectors.toList()));
        }

        @Override
        public JDA getElementById(int id) {
            return this.generator.get().map(view -> view.getElementById(id)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        @Override
        public Stream<JDA> stream() {
            return this.generator.get().flatMap(CacheView::stream).distinct();
        }

        @Override
        public Stream<JDA> parallelStream() {
            return this.generator.get().flatMap(CacheView::parallelStream).distinct();
        }

        @Override
        @Nonnull
        public Iterator<JDA> iterator() {
            return this.asList().iterator();
        }
    }
}

