/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.client.managers;

import chikachi.discord.repack.net.dv8tion.jda.client.managers.fields.EmoteField;
import chikachi.discord.repack.net.dv8tion.jda.core.JDA;
import chikachi.discord.repack.net.dv8tion.jda.core.Permission;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Emote;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Guild;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.ISnowflake;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Role;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.EmoteImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Request;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Response;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.Route;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.Checks;
import chikachi.discord.repack.org.json.JSONObject;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;

public class EmoteManagerUpdatable {
    public static final Pattern NAME_PATTERN = Pattern.compile("^\\w+$");
    protected final EmoteImpl emote;
    protected EmoteField<String> name;
    protected EmoteField<Collection<Role>> roles;

    public EmoteManagerUpdatable(EmoteImpl emote) {
        if (emote.isFake()) {
            throw new IllegalStateException("The emote you are trying to update is not an actual emote we have access to (it is fake)!");
        }
        if (emote.isManaged()) {
            throw new IllegalStateException("You cannot modify a managed emote!");
        }
        this.emote = emote;
        this.checkPermission(Permission.MANAGE_EMOTES);
        this.setupFields();
    }

    public JDA getJDA() {
        return this.emote.getJDA();
    }

    public Guild getGuild() {
        return this.emote.getGuild();
    }

    public Emote getEmote() {
        return this.emote;
    }

    public EmoteField<String> getNameField() {
        return this.name;
    }

    public EmoteField<Collection<Role>> getRolesField() {
        return this.roles;
    }

    public void reset() {
        this.name.reset();
        this.roles.reset();
    }

    @CheckReturnValue
    public AuditableRestAction<Void> update() {
        this.checkPermission(Permission.MANAGE_EMOTES);
        if (!this.needsUpdate()) {
            return new AuditableRestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        JSONObject body = new JSONObject();
        if (this.name.shouldUpdate()) {
            body.put("name", this.name.getValue());
        }
        if (this.roles.shouldUpdate()) {
            body.put("roles", ((Collection)this.roles.getValue()).stream().map(ISnowflake::getId).collect(Collectors.toList()));
        }
        this.reset();
        Route.CompiledRoute route = Route.Emotes.MODIFY_EMOTE.compile(this.getGuild().getId(), this.emote.getId());
        return new AuditableRestAction<Void>(this.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    protected boolean needsUpdate() {
        return this.name.shouldUpdate() || this.roles.shouldUpdate();
    }

    protected void checkPermission(Permission perm) {
        if (!this.getGuild().getSelfMember().hasPermission(perm)) {
            throw new InsufficientPermissionException(perm);
        }
    }

    protected void setupFields() {
        this.name = new EmoteField<String>(this, this.emote::getName){

            @Override
            public void checkValue(String value) {
                Checks.notNull(value, "emote name");
                if (value.length() < 2 || value.length() > 32) {
                    throw new IllegalArgumentException("Emote name must be 2 to 32 characters in length");
                }
                Matcher nameMatcher = NAME_PATTERN.matcher(value);
                if (!nameMatcher.find()) {
                    throw new IllegalArgumentException("Provided name must be Alphanumeric characters and underscores. (a-z A-Z 0-9 _)");
                }
            }
        };
        this.roles = new EmoteField<Collection<Role>>(this, this.emote::getRoles){

            @Override
            public void checkValue(Collection<Role> value) {
                Checks.notNull(value, "Role Collection");
                value.forEach(r -> Checks.notNull(r, "Role in Collection"));
            }
        };
    }
}

