/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.handle;

import chikachi.discord.repack.net.dv8tion.jda.core.entities.Emote;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Role;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.EmoteImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.events.emote.EmoteAddedEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.emote.EmoteRemovedEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.emote.update.EmoteUpdateNameEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.emote.update.EmoteUpdateRolesEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.EventCache;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.SocketHandler;
import chikachi.discord.repack.org.apache.commons.collections4.CollectionUtils;
import chikachi.discord.repack.org.json.JSONArray;
import chikachi.discord.repack.org.json.JSONObject;
import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class GuildEmojisUpdateHandler
extends SocketHandler {
    public GuildEmojisUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long guildId = content.getLong("guild_id");
        if (this.api.getGuildLock().isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
        if (guild == null) {
            this.api.getEventCache().cache(EventCache.Type.GUILD, guildId, () -> this.handle(this.responseNumber, this.allContent));
            return null;
        }
        JSONArray array = content.getJSONArray("emojis");
        TLongObjectMap<Emote> emoteMap = guild.getEmoteMap();
        ArrayList<Emote> oldEmotes = new ArrayList<Emote>(emoteMap.valueCollection());
        ArrayList<EmoteImpl> newEmotes = new ArrayList<EmoteImpl>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject jSONObject = array.getJSONObject(i);
            long emoteId = jSONObject.getLong("id");
            EmoteImpl emote = (EmoteImpl)emoteMap.get(emoteId);
            EmoteImpl oldEmote = null;
            if (emote == null) {
                emote = new EmoteImpl(emoteId, guild);
                newEmotes.add(emote);
            } else {
                oldEmotes.remove(emote);
                oldEmote = emote.clone();
            }
            emote.setName(jSONObject.getString("name")).setAnimated(jSONObject.optBoolean("animated")).setManaged(jSONObject.getBoolean("managed"));
            JSONArray roles = jSONObject.getJSONArray("roles");
            Set<Role> newRoles = emote.getRoleSet();
            HashSet<Role> oldRoles = new HashSet<Role>(newRoles);
            for (int j = 0; j < roles.length(); ++j) {
                Role role = guild.getRoleById(roles.getString(j));
                newRoles.add(role);
                oldRoles.remove(role);
            }
            for (Role r : oldRoles) {
                newRoles.remove(r);
            }
            emoteMap.put(emote.getIdLong(), emote);
            this.handleReplace(oldEmote, emote);
        }
        for (Emote emote : oldEmotes) {
            emoteMap.remove(emote.getIdLong());
            this.api.getEventManager().handle(new EmoteRemovedEvent(this.api, this.responseNumber, emote));
        }
        for (Emote emote : newEmotes) {
            this.api.getEventManager().handle(new EmoteAddedEvent(this.api, this.responseNumber, emote));
        }
        return null;
    }

    private void handleReplace(Emote oldEmote, Emote newEmote) {
        if (oldEmote == null || newEmote == null) {
            return;
        }
        if (!Objects.equals(oldEmote.getName(), newEmote.getName())) {
            this.api.getEventManager().handle(new EmoteUpdateNameEvent(this.api, this.responseNumber, newEmote, oldEmote.getName()));
        }
        if (!CollectionUtils.isEqualCollection(oldEmote.getRoles(), newEmote.getRoles())) {
            this.api.getEventManager().handle(new EmoteUpdateRolesEvent(this.api, this.responseNumber, newEmote, oldEmote.getRoles()));
        }
    }
}

