/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.handle;

import chikachi.discord.repack.net.dv8tion.jda.client.events.message.group.react.GroupMessageReactionAddEvent;
import chikachi.discord.repack.net.dv8tion.jda.client.events.message.group.react.GroupMessageReactionRemoveEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.AccountType;
import chikachi.discord.repack.net.dv8tion.jda.core.JDA;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.Emote;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.MessageChannel;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.MessageReaction;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.User;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.EmoteImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.events.message.guild.react.GuildMessageReactionAddEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.message.guild.react.GuildMessageReactionRemoveEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.message.priv.react.PrivateMessageReactionAddEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.message.priv.react.PrivateMessageReactionRemoveEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.message.react.MessageReactionAddEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.events.message.react.MessageReactionRemoveEvent;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.EventCache;
import chikachi.discord.repack.net.dv8tion.jda.core.handle.SocketHandler;
import chikachi.discord.repack.net.dv8tion.jda.core.hooks.IEventManager;
import chikachi.discord.repack.net.dv8tion.jda.core.requests.WebSocketClient;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.JDALogger;
import chikachi.discord.repack.org.json.JSONObject;

public class MessageReactionHandler
extends SocketHandler {
    private final boolean add;

    public MessageReactionHandler(JDAImpl api, boolean add) {
        super(api);
        this.add = add;
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        MessageReaction.ReactionEmote rEmote;
        JSONObject emoji = content.getJSONObject("emoji");
        long userId = content.getLong("user_id");
        long messageId = content.getLong("message_id");
        long channelId = content.getLong("channel_id");
        Long emojiId = emoji.isNull("id") ? null : Long.valueOf(emoji.getLong("id"));
        String emojiName = emoji.optString("name", null);
        boolean emojiAnimated = emoji.optBoolean("animated");
        if (emojiId == null && emojiName == null) {
            WebSocketClient.LOG.debug("Received a reaction {} with no name nor id. json: {}", JDALogger.getLazyString(() -> this.add ? "add" : "remove"), (Object)content);
            return null;
        }
        User user = this.api.getUserById(userId);
        if (user == null) {
            user = this.api.getFakeUserMap().get(userId);
        }
        if (user == null) {
            this.api.getEventCache().cache(EventCache.Type.USER, userId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a reaction for a user that JDA does not currently have cached");
            return null;
        }
        MessageChannel channel = this.api.getTextChannelById(channelId);
        if (channel == null) {
            channel = this.api.getPrivateChannelById(channelId);
        }
        if (channel == null) {
            channel = this.api.getFakePrivateChannelMap().get(channelId);
        }
        if (channel == null && this.api.getAccountType() == AccountType.CLIENT) {
            channel = this.api.asClient().getGroupById(channelId);
        }
        if (channel == null) {
            this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a reaction for a channel that JDA does not currently have cached");
            return null;
        }
        if (emojiId != null) {
            Emote emote = this.api.getEmoteById(emojiId);
            if (emote == null) {
                if (emojiName != null) {
                    emote = new EmoteImpl((long)emojiId, this.api).setAnimated(emojiAnimated).setName(emojiName);
                } else {
                    WebSocketClient.LOG.debug("Received a reaction {} with a null name. json: {}", JDALogger.getLazyString(() -> this.add ? "add" : "remove"), (Object)content);
                    return null;
                }
            }
            rEmote = new MessageReaction.ReactionEmote(emote);
        } else {
            rEmote = new MessageReaction.ReactionEmote(emojiName, null, this.api);
        }
        MessageReaction reaction = new MessageReaction(channel, rEmote, messageId, user.equals(this.api.getSelfUser()), -1);
        if (this.add) {
            this.onAdd(reaction, user);
        } else {
            this.onRemove(reaction, user);
        }
        return null;
    }

    private void onAdd(MessageReaction reaction, User user) {
        IEventManager manager = this.api.getEventManager();
        switch (reaction.getChannelType()) {
            case TEXT: {
                manager.handle(new GuildMessageReactionAddEvent((JDA)this.api, this.responseNumber, user, reaction));
                break;
            }
            case GROUP: {
                manager.handle(new GroupMessageReactionAddEvent((JDA)this.api, this.responseNumber, user, reaction));
                break;
            }
            case PRIVATE: {
                manager.handle(new PrivateMessageReactionAddEvent((JDA)this.api, this.responseNumber, user, reaction));
            }
        }
        manager.handle(new MessageReactionAddEvent((JDA)this.api, this.responseNumber, user, reaction));
    }

    private void onRemove(MessageReaction reaction, User user) {
        IEventManager manager = this.api.getEventManager();
        switch (reaction.getChannelType()) {
            case TEXT: {
                manager.handle(new GuildMessageReactionRemoveEvent((JDA)this.api, this.responseNumber, user, reaction));
                break;
            }
            case GROUP: {
                manager.handle(new GroupMessageReactionRemoveEvent((JDA)this.api, this.responseNumber, user, reaction));
                break;
            }
            case PRIVATE: {
                manager.handle(new PrivateMessageReactionRemoveEvent((JDA)this.api, this.responseNumber, user, reaction));
            }
        }
        manager.handle(new MessageReactionRemoveEvent((JDA)this.api, this.responseNumber, user, reaction));
    }
}

