/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.requests;

import chikachi.discord.repack.net.dv8tion.jda.core.JDA;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.JDALogger;
import chikachi.discord.repack.org.json.JSONObject;
import chikachi.discord.repack.org.slf4j.Logger;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.LinkedList;
import java.util.List;

public class GuildLock {
    public static final Logger LOG = JDALogger.getLog(GuildLock.class);
    private final JDA api;
    private final TLongObjectMap<List<JSONObject>> cache = new TLongObjectHashMap<List<JSONObject>>();
    private final TLongSet cached = new TLongHashSet();

    public boolean isLocked(long guildId) {
        return this.cached.contains(guildId);
    }

    public void lock(long guildId) {
        if (!this.isLocked(guildId)) {
            this.cached.add(guildId);
            this.cache.put(guildId, new LinkedList());
        }
    }

    public void unlock(long guildId) {
        if (this.isLocked(guildId)) {
            this.cached.remove(guildId);
            List<JSONObject> events = this.cache.remove(guildId);
            if (events.size() > 0) {
                LOG.debug("Replaying {} events for unlocked guild with id {}", (Object)events.size(), (Object)guildId);
                ((JDAImpl)this.api).getClient().handle(events);
                LOG.debug("Finished replaying events for guild with id {}", (Object)guildId);
            }
        }
    }

    public void queue(long guildId, JSONObject event) {
        if (this.isLocked(guildId)) {
            LOG.debug("Queueing up event for guild with id {}: {}", (Object)guildId, (Object)event);
            this.cache.get(guildId).add(event);
        }
    }

    public void clear() {
        this.cache.clear();
        this.cached.clear();
    }

    public GuildLock(JDA api) {
        this.api = api;
    }
}

