/*
 * Decompiled with CFR 0.152.
 */
package chikachi.discord.repack.net.dv8tion.jda.core.utils.cache;

import chikachi.discord.repack.net.dv8tion.jda.bot.utils.cache.ShardCacheView;
import chikachi.discord.repack.net.dv8tion.jda.bot.utils.cache.impl.ShardCacheViewImpl;
import chikachi.discord.repack.net.dv8tion.jda.core.entities.ISnowflake;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.Checks;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.cache.MemberCacheView;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.cache.SnowflakeCacheView;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.cache.UnifiedMemberCacheView;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.cache.impl.AbstractCacheView;
import chikachi.discord.repack.net.dv8tion.jda.core.utils.cache.impl.UnifiedCacheViewImpl;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public interface CacheView<T>
extends Iterable<T> {
    public List<T> asList();

    public Set<T> asSet();

    public long size();

    public boolean isEmpty();

    public List<T> getElementsByName(String var1, boolean var2);

    default public List<T> getElementsByName(String name) {
        return this.getElementsByName(name, false);
    }

    public Stream<T> stream();

    public Stream<T> parallelStream();

    default public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.stream().collect(collector);
    }

    public static <E> CacheView<E> all(Collection<? extends CacheView<E>> cacheViews) {
        Checks.noneNull(cacheViews, "Collection");
        return new UnifiedCacheViewImpl(cacheViews::stream);
    }

    public static <E> CacheView<E> all(Supplier<Stream<CacheView<E>>> generator) {
        Checks.notNull(generator, "Generator");
        return new UnifiedCacheViewImpl(generator);
    }

    public static ShardCacheView allShards(Collection<ShardCacheView> cacheViews) {
        Checks.noneNull(cacheViews, "Collection");
        return new ShardCacheViewImpl.UnifiedShardCacheViewImpl(cacheViews::stream);
    }

    public static ShardCacheView allShards(Supplier<Stream<ShardCacheView>> generator) {
        Checks.notNull(generator, "Generator");
        return new ShardCacheViewImpl.UnifiedShardCacheViewImpl(generator);
    }

    public static <E extends ISnowflake> SnowflakeCacheView<E> allSnowflakes(Collection<SnowflakeCacheView<E>> cacheViews) {
        Checks.noneNull(cacheViews, "Collection");
        return new UnifiedCacheViewImpl.UnifiedSnowflakeCacheView(cacheViews::stream);
    }

    public static <E extends ISnowflake> SnowflakeCacheView<E> allSnowflakes(Supplier<Stream<SnowflakeCacheView<E>>> generator) {
        Checks.notNull(generator, "Generator");
        return new UnifiedCacheViewImpl.UnifiedSnowflakeCacheView(generator);
    }

    public static UnifiedMemberCacheView allMembers(Collection<MemberCacheView> cacheViews) {
        Checks.noneNull(cacheViews, "Collection");
        return new UnifiedCacheViewImpl.UnifiedMemberCacheViewImpl(cacheViews::stream);
    }

    public static UnifiedMemberCacheView allMembers(Supplier<Stream<MemberCacheView>> generator) {
        Checks.notNull(generator, "Generator");
        return new UnifiedCacheViewImpl.UnifiedMemberCacheViewImpl(generator);
    }

    public static class SimpleCacheView<T>
    extends AbstractCacheView<T> {
        public SimpleCacheView(Function<T, String> nameMapper) {
            super(nameMapper);
        }
    }
}

