/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.item;

import doggytalents.entity.ai.DogLocationManager;
import doggytalents.item.ItemDT;
import doggytalents.item.ItemRadar;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRadarCreative
extends ItemDT {
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            int dimCurr = playerIn.field_71093_bK;
            playerIn.func_145747_a((ITextComponent)new TextComponentString(""));
            DogLocationManager locationManager = DogLocationManager.getHandler(worldIn);
            List<DogLocationManager.DogLocation> ownDogs = locationManager.getList(dimCurr, loc -> loc.getOwner(worldIn) == playerIn);
            if (ownDogs.isEmpty()) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("dogradar.errornull", new Object[]{String.valueOf(dimCurr)}));
            } else {
                for (DogLocationManager.DogLocation loc2 : ownDogs) {
                    String translateStr = ItemRadar.getDirectionTranslationKey(loc2, (Entity)playerIn);
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation(translateStr, new Object[]{loc2.getName(worldIn), (int)Math.ceil(playerIn.func_70011_f(loc2.x, loc2.y, loc2.z))}));
                }
            }
            HashSet<Integer> otherDogs = new HashSet<Integer>();
            List<DogLocationManager.DogLocation> allDogs = locationManager.getAll(loc -> loc.getOwner(worldIn) == playerIn);
            for (DogLocationManager.DogLocation loc3 : allDogs) {
                if (dimCurr == loc3.dim) continue;
                otherDogs.add(loc3.dim);
            }
            if (otherDogs.size() > 0) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("dogradar.notindim", new Object[]{otherDogs.stream().map(ItemRadarCreative::getDimensionName).collect(Collectors.joining(", "))}));
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
    }

    public static String getDimensionName(int dim) {
        DimensionType type = DimensionManager.getProviderType((int)dim);
        if (type != null) {
            return type.func_186065_b();
        }
        return "ID: " + dim;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TextComponentTranslation(this.func_77658_a() + ".tooltip", new Object[0]).func_150254_d());
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }
}

