/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.client.utils;

import c4.conarm.ConstructsArmory;
import c4.conarm.lib.armor.ArmorCore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.apache.commons.io.FilenameUtils;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.model.MaterialModel;
import slimeknights.tconstruct.library.client.model.MaterialModelLoader;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.client.model.ModifierModel;
import slimeknights.tconstruct.library.client.model.ModifierModelLoader;
import slimeknights.tconstruct.library.client.model.ToolModel;
import slimeknights.tconstruct.library.client.model.format.AmmoPosition;
import slimeknights.tconstruct.library.client.model.format.ToolModelOverride;
import slimeknights.tconstruct.library.tools.IToolPart;

public class ArmorModelLoader
implements ICustomModelLoader {
    public static String EXTENSION = ".conarm";
    private static final Map<ResourceLocation, ArmorCore> modelItemMap = Maps.newHashMap();

    public static void addPartMapping(ResourceLocation resourceLocation, ArmorCore armor) {
        modelItemMap.put(resourceLocation, armor);
    }

    public boolean accepts(@Nonnull ResourceLocation modelLocation) {
        return modelLocation.func_110623_a().endsWith(EXTENSION);
    }

    @Nonnull
    public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
        try {
            Map textures = ModelHelper.loadTexturesFromJson((ResourceLocation)modelLocation);
            ImmutableMap transforms = ModelHelper.loadTransformFromJson((ResourceLocation)modelLocation);
            ImmutableList overrides = ModelHelper.loadToolModelOverridesFromJson((ResourceLocation)modelLocation);
            AmmoPosition ammoPosition = ModelHelper.loadAmmoPositionFromJson((ResourceLocation)modelLocation);
            Float[] rotations = ModelHelper.loadLayerRotations((ResourceLocation)modelLocation);
            if (rotations.length > 0 && textures.size() != rotations.length) {
                ConstructsArmory.logger.error("Armormodel {} has invalid layerrotation entry: Size should be {} but is {}; Skipping rotations.", (Object)modelLocation, (Object)textures.size(), (Object)rotations.length);
                rotations = new Float[]{};
            }
            ImmutableList.Builder defaultTextureListBuilder = ImmutableList.builder();
            ArrayList parts = Lists.newArrayList();
            ArrayList brokenParts = Lists.newArrayList();
            ArmorCore armorCore = modelItemMap.get(MaterialModelLoader.getReducedPath((ResourceLocation)modelLocation));
            for (Map.Entry entry : textures.entrySet()) {
                String name = (String)entry.getKey();
                try {
                    ArrayList listToAdd;
                    int i;
                    if (name.startsWith("layer")) {
                        i = Integer.valueOf(name.substring(5));
                        listToAdd = parts;
                    } else if (name.startsWith("broken")) {
                        i = Integer.valueOf(name.substring(6));
                        listToAdd = brokenParts;
                    } else {
                        ConstructsArmory.logger.warn("Armormodel {} has invalid texture entry {}; Skipping layer.", (Object)modelLocation, (Object)name);
                        continue;
                    }
                    ResourceLocation location = new ResourceLocation((String)entry.getValue());
                    MaterialModel partModel = new MaterialModel(ImmutableList.of((Object)location));
                    while (listToAdd.size() <= i) {
                        listToAdd.add(null);
                    }
                    listToAdd.set(i, partModel);
                    defaultTextureListBuilder.add((Object)location);
                    this.registerCustomTextures(i, location, armorCore);
                }
                catch (NumberFormatException e) {
                    ConstructsArmory.logger.error("Armormodel {} has invalid texture entry {}; Skipping layer.", (Object)modelLocation, (Object)name);
                }
            }
            for (ToolModelOverride override : overrides) {
                for (Map.Entry entry : override.textures.entrySet()) {
                    String name = (String)entry.getKey();
                    try {
                        TIntObjectHashMap mapToAdd;
                        int i;
                        if (name.startsWith("layer")) {
                            i = Integer.valueOf(name.substring(5));
                            mapToAdd = override.partModelReplacement;
                        } else if (name.startsWith("broken")) {
                            i = Integer.valueOf(name.substring(6));
                            mapToAdd = override.brokenPartModelReplacement;
                        } else {
                            ConstructsArmory.logger.warn("Armormodel {} has invalid texture override entry {}; Skipping layer.", (Object)modelLocation, (Object)name);
                            continue;
                        }
                        ResourceLocation location = new ResourceLocation((String)entry.getValue());
                        MaterialModel partModel = new MaterialModel(ImmutableList.of((Object)location));
                        mapToAdd.put(i, (Object)partModel);
                        this.registerCustomTextures(i, location, armorCore);
                    }
                    catch (NumberFormatException e) {
                        ConstructsArmory.logger.error("Armormodel {} has invalid texture entry {}; Skipping layer.", (Object)modelLocation, (Object)name);
                    }
                }
            }
            String toolName = FilenameUtils.getBaseName((String)modelLocation.func_110623_a());
            ModifierModel modifiers = null;
            try {
                IModel mods = ModelLoaderRegistry.getModel((ResourceLocation)ModifierModelLoader.getLocationForToolModifiers((String)modelLocation.func_110624_b(), (String)toolName));
                if (mods == null || !(mods instanceof ModifierModel)) {
                    ConstructsArmory.logger.trace("Armormodel {} does not have any modifiers associated with it. Be sure that the Armors internal name, the Armormodels filename and the name used inside the Modifier Model Definition match!", (Object)modelLocation);
                } else {
                    modifiers = (ModifierModel)mods;
                    for (ToolModelOverride toolModelOverride : overrides) {
                        if (toolModelOverride.modifierSuffix == null) continue;
                        String modifierName = toolName + toolModelOverride.modifierSuffix;
                        IModel extraModel = ModelLoaderRegistry.getModel((ResourceLocation)ModifierModelLoader.getLocationForToolModifiers((String)modelLocation.func_110624_b(), (String)modifierName));
                        if (!(extraModel instanceof ModifierModel)) continue;
                        ModifierModel overriddenModifierModel = new ModifierModel();
                        for (Map.Entry entry : modifiers.getModels().entrySet()) {
                            overriddenModifierModel.addModelForModifier((String)entry.getKey(), (String)entry.getValue());
                        }
                        for (Map.Entry entry : ((ModifierModel)extraModel).getModels().entrySet()) {
                            overriddenModifierModel.addModelForModifier((String)entry.getKey(), (String)entry.getValue());
                        }
                        toolModelOverride.overrideModifierModel = overriddenModifierModel;
                    }
                }
            }
            catch (Exception e) {
                ConstructsArmory.logger.error((Object)e);
                modifiers = null;
            }
            return new ToolModel(defaultTextureListBuilder.build(), (List)parts, (List)brokenParts, rotations, modifiers, transforms, overrides, ammoPosition);
        }
        catch (IOException e) {
            ConstructsArmory.logger.error("Could not load multimodel {}", (Object)modelLocation.toString());
            return ModelLoaderRegistry.getMissingModel();
        }
    }

    private void registerCustomTextures(int i, ResourceLocation resourceLocation, ArmorCore armorCore) {
        if (armorCore == null) {
            CustomTextureCreator.registerTexture((ResourceLocation)resourceLocation);
        } else {
            for (IToolPart part : armorCore.getRequiredComponents().get(i).getPossibleParts()) {
                CustomTextureCreator.registerTextureForPart((ResourceLocation)resourceLocation, (IToolPart)part);
            }
        }
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
    }
}

