/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.modifiers;

import c4.conarm.common.ConstructsRegistry;
import c4.conarm.common.armor.utils.ArmorTagUtil;
import c4.conarm.lib.armor.ArmorNBT;
import c4.conarm.lib.client.IArmorMaterialTexture;
import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.tinkering.TinkersArmor;
import c4.conarm.lib.utils.RecipeMatchHolder;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerAPIException;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.modifiers.ToolModifier;

public class ModPolished
extends ToolModifier
implements IArmorMaterialTexture {
    public final Material material;

    public ModPolished(Material material) {
        super("polished_armor" + material.getIdentifier(), material.materialTextColor);
        if (!material.hasStats(ArmorMaterialType.PLATES)) {
            throw new TinkerAPIException(String.format("Trying to add a polished-modifier for a material without armor stats: %s", material.getIdentifier()));
        }
        this.material = material;
        this.addAspects(new ModifierAspect[]{new ModifierAspect.SingleAspect((IModifier)this), new ModifierAspect.DataAspect((IModifier)this)});
        ItemStack kit = ConstructsRegistry.polishingKit.getItemstackWithMaterial(material);
        ItemStack sand = new ItemStack((Block)Blocks.field_150354_m);
        RecipeMatchHolder.addRecipeMatch((IModifier)this, (RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{kit, sand}));
    }

    @Override
    public String getBaseTexture() {
        return "conarm:models/modifiers/mod_polished_armor_" + this.material.getIdentifier();
    }

    public String getLocalizedName() {
        return Util.translate((String)"modifier.%s.name", (Object[])new Object[]{"polished_armor"}) + " (" + this.material.getLocalizedName() + ")";
    }

    public String getLocalizedDesc() {
        return Util.translateFormatted((String)String.format("modifier.%s.desc", "polished_armor"), (Object[])new Object[]{this.material.getLocalizedName()});
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        ArmorNBT data = ArmorTagUtil.getArmorStats(rootCompound);
        float matToughness = ((PlatesMaterialStats)this.material.getStats((String)ArmorMaterialType.PLATES)).toughness;
        float originalToughness = ArmorTagUtil.getOriginalArmorStats((NBTTagCompound)rootCompound).toughness;
        float addedToughness = Math.max(0.0f, matToughness - originalToughness);
        if (addedToughness > 0.0f) {
            data.toughness += addedToughness;
            TagUtil.setToolTag((NBTTagCompound)rootCompound, (NBTTagCompound)data.get());
        }
        NBTTagList tagList = TagUtil.getModifiersTagList((NBTTagCompound)rootCompound);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound mod = tagList.func_150305_b(i);
            ModifierNBT modData = ModifierNBT.readTag((NBTTagCompound)mod);
            if (modData.identifier.equals(this.identifier)) break;
            if (!modData.identifier.startsWith("polished_armor")) continue;
            tagList.func_74744_a(i);
            --i;
        }
        TagUtil.setModifiersTagList((NBTTagCompound)rootCompound, (NBTTagList)tagList);
    }

    public boolean canApplyCustom(ItemStack stack) {
        return stack.func_77973_b() instanceof TinkersArmor;
    }

    public boolean hasTexturePerMaterial() {
        return true;
    }
}

