/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.traits;

import c4.conarm.lib.traits.AbstractArmorTrait;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitRough
extends AbstractArmorTrait {
    public TraitRough() {
        super("rough", TextFormatting.AQUA);
    }

    private double calcAttack(ItemStack armor) {
        int durability = ToolHelper.getCurrentDurability((ItemStack)armor);
        int maxDurability = ToolHelper.getMaxDurability((ItemStack)armor);
        return Math.log((double)(maxDurability - durability) / 72.0 + 1.0) * 2.0;
    }

    @Override
    public float onHurt(ItemStack armor, EntityPlayer player, DamageSource source, float damage, float newDamage, LivingHurtEvent evt) {
        if (source.func_76364_f() instanceof EntityLivingBase) {
            TraitRough.attackEntitySecondary((DamageSource)new EntityDamageSource("prismarine", (Entity)player).func_180138_v(), (float)((float)this.calcAttack(armor)), (Entity)source.func_76364_f(), (boolean)true, (boolean)false, (boolean)false);
        }
        return newDamage;
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getModifierIdentifier());
        return ImmutableList.of((Object)Util.translateFormatted((String)loc, (Object[])new Object[]{Util.df.format(this.calcAttack(tool))}));
    }
}

