/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.traits;

import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.lib.traits.AbstractArmorTrait;
import com.google.common.collect.Multimap;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TraitSteady
extends AbstractArmorTrait {
    protected static final UUID[] KNOCKBACK_MODIFIERS = new UUID[]{UUID.fromString("e2b8e0eb-7f25-4d61-aa05-e944b0ef405e"), UUID.fromString("5386d00f-8016-46c7-85fd-d3327e6b28fd"), UUID.fromString("d1d85377-7d7f-4918-be58-6ab27f41be3d"), UUID.fromString("7cb4787d-9060-4274-ba90-03227daae664")};
    private static final double KNOCKBACK_RESIST_PER_LEVEL = 0.1;

    public TraitSteady() {
        super("steady", 0xFFFFFF);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack, Multimap<String, AttributeModifier> attributeMap) {
        if (slot == EntityLiving.func_184640_d((ItemStack)stack)) {
            attributeMap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(KNOCKBACK_MODIFIERS[slot.func_188454_b()], "Steady trait modifier", 0.1, 0));
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent evt) {
        if (evt.getEntityLiving() instanceof EntityPlayer && evt.getSource().func_76364_f() instanceof EntityLivingBase) {
            EntityPlayer player = (EntityPlayer)evt.getEntityLiving();
            EntityLivingBase entity = (EntityLivingBase)evt.getSource().func_76364_f();
            int level = (int)ArmorHelper.getArmorAbilityLevel(player, this.identifier);
            if (level > 0) {
                entity.func_70653_a((Entity)entity, 0.2f * (float)level, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
            }
        }
    }
}

