/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.netsync;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.ndrei.teslacorelib.TeslaCoreLib;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B#\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R(\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R*\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R(\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\r\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006$"}, d2={"Lnet/ndrei/teslacorelib/netsync/SimpleNBTMessage;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "()V", "entity", "Lnet/minecraft/tileentity/TileEntity;", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "(Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/nbt/NBTTagCompound;)V", "pos", "Lnet/minecraft/util/math/BlockPos;", "dimension", "", "(Lnet/minecraft/util/math/BlockPos;Ljava/lang/Integer;Lnet/minecraft/nbt/NBTTagCompound;)V", "<set-?>", "getCompound", "()Lnet/minecraft/nbt/NBTTagCompound;", "setCompound", "(Lnet/minecraft/nbt/NBTTagCompound;)V", "getDimension", "()Ljava/lang/Integer;", "setDimension", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getPos", "()Lnet/minecraft/util/math/BlockPos;", "setPos", "(Lnet/minecraft/util/math/BlockPos;)V", "targetPoint", "Lnet/minecraftforge/fml/common/network/NetworkRegistry$TargetPoint;", "getTargetPoint", "()Lnet/minecraftforge/fml/common/network/NetworkRegistry$TargetPoint;", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "tesla-core-lib"})
public final class SimpleNBTMessage
implements IMessage {
    @Nullable
    private NBTTagCompound compound;
    @Nullable
    private BlockPos pos;
    @Nullable
    private Integer dimension;

    @Nullable
    public final NBTTagCompound getCompound() {
        return this.compound;
    }

    private final void setCompound(NBTTagCompound nBTTagCompound) {
        this.compound = nBTTagCompound;
    }

    @Nullable
    public final BlockPos getPos() {
        return this.pos;
    }

    private final void setPos(BlockPos blockPos) {
        this.pos = blockPos;
    }

    @Nullable
    public final Integer getDimension() {
        return this.dimension;
    }

    private final void setDimension(Integer n) {
        this.dimension = n;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        NBTTagCompound nBTTagCompound;
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        NBTTagCompound pos = ByteBufUtils.readTag((ByteBuf)buf);
        if (pos != null) {
            this.pos = new BlockPos(pos.func_74762_e("x"), pos.func_74762_e("y"), pos.func_74762_e("z"));
            this.dimension = pos.func_74762_e("dim");
        } else {
            TeslaCoreLib.INSTANCE.getLogger().warn("Network package received with missing BlockPos information.");
            this.pos = new BlockPos(0, 0, 0);
            this.dimension = 0;
        }
        if ((nBTTagCompound = ByteBufUtils.readTag((ByteBuf)buf)) == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        this.compound = nBTTagCompound;
    }

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        NBTTagCompound pos = new NBTTagCompound();
        if (this.pos != null) {
            BlockPos blockPos = this.pos;
            if (blockPos == null) {
                Intrinsics.throwNpe();
            }
            pos.func_74768_a("x", blockPos.func_177958_n());
            BlockPos blockPos2 = this.pos;
            if (blockPos2 == null) {
                Intrinsics.throwNpe();
            }
            pos.func_74768_a("y", blockPos2.func_177956_o());
            BlockPos blockPos3 = this.pos;
            if (blockPos3 == null) {
                Intrinsics.throwNpe();
            }
            pos.func_74768_a("z", blockPos3.func_177952_p());
        }
        if (this.dimension != null) {
            Integer n = this.dimension;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            pos.func_74768_a("dim", n.intValue());
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)pos);
        if (this.compound != null) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.compound);
        }
    }

    @Nullable
    public final NetworkRegistry.TargetPoint getTargetPoint() {
        NetworkRegistry.TargetPoint targetPoint;
        if (this.dimension != null && this.pos != null) {
            Integer n = this.dimension;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            int n2 = n;
            BlockPos blockPos = this.pos;
            if (blockPos == null) {
                Intrinsics.throwNpe();
            }
            double d = blockPos.func_177958_n();
            BlockPos blockPos2 = this.pos;
            if (blockPos2 == null) {
                Intrinsics.throwNpe();
            }
            double d2 = blockPos2.func_177956_o();
            BlockPos blockPos3 = this.pos;
            if (blockPos3 == null) {
                Intrinsics.throwNpe();
            }
            targetPoint = new NetworkRegistry.TargetPoint(n2, d, d2, (double)blockPos3.func_177952_p(), 64.0);
        } else {
            targetPoint = null;
        }
        return targetPoint;
    }

    public SimpleNBTMessage(@Nullable BlockPos pos, @Nullable Integer dimension, @Nullable NBTTagCompound compound) {
        this.pos = pos;
        this.dimension = dimension;
        this.compound = compound;
    }

    public SimpleNBTMessage() {
        this(null, null, null);
    }

    public SimpleNBTMessage(@NotNull TileEntity entity, @NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        BlockPos blockPos = entity.func_174877_v();
        WorldProvider worldProvider = entity.func_145831_w().field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"entity.world.provider");
        this(blockPos, worldProvider.getDimension(), compound);
    }
}

