/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.core.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thedarkcolour.core.util.UtilKt;
import thedarkcolour.futuremc.FutureMC;

public final class Generator {
    public static void setup() {
        if (FutureMC.DEBUG) {
            Generator.generateFolders();
        }
    }

    public static void generateFolders() {
        File blockStates = new File("config/futuremc/generated/blockstates/");
        File registry = new File("config/futuremc/generated/registry/");
        blockStates.mkdirs();
        registry.mkdirs();
    }

    public static void generateRegistries() {
        Generator.generateRegistry(ForgeRegistries.BIOMES);
        Generator.generateRegistry(ForgeRegistries.BLOCKS);
        Generator.generateRegistry(ForgeRegistries.ENCHANTMENTS);
        Generator.generateRegistry(ForgeRegistries.ENTITIES);
        Generator.generateRegistry(ForgeRegistries.ITEMS);
        Generator.generateRegistry(ForgeRegistries.SOUND_EVENTS);
    }

    private static <V extends IForgeRegistryEntry<V>> void generateRegistry(IForgeRegistry<V> registry) {
        File file = new File("config/future-mc/generated/registry/" + registry.getRegistrySuperType().getName().toLowerCase() + ".txt");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            if (!file.canWrite()) {
                file.setWritable(true);
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            for (ResourceLocation key : UtilKt.make(new HashSet(registry.getKeys()), keys -> keys.removeIf(key -> !key.func_110624_b().equals("minecraftfuture") && !key.func_110624_b().equals("minecraftfuture")))) {
                writer.write(key.toString());
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateMappedRegistries() {
        Generator.generateMappedRegistry(ForgeRegistries.BIOMES);
        Generator.generateMappedRegistry(ForgeRegistries.BLOCKS);
        Generator.generateMappedRegistry(ForgeRegistries.ENCHANTMENTS);
        Generator.generateMappedRegistry(ForgeRegistries.ENTITIES);
        Generator.generateMappedRegistry(ForgeRegistries.ITEMS);
        Generator.generateMappedRegistry(ForgeRegistries.SOUND_EVENTS);
    }

    private static <V extends IForgeRegistryEntry<V>> void generateMappedRegistry(IForgeRegistry<V> registry) {
        File file = new File("config/future-mc/generated/registry/" + registry.getRegistrySuperType().getName().toLowerCase() + ".txt");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            if (!file.canWrite()) {
                file.setWritable(true);
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            for (ResourceLocation key : UtilKt.make(new HashSet(registry.getKeys()), keys -> keys.removeIf(key -> !key.func_110624_b().equals("minecraftfuture") && !key.func_110624_b().equals("minecraftfuture")))) {
                writer.write(key.toString() + ", " + key.toString().replaceFirst("minecraftfuture", "futuremc"));
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateBlockStates() {
        for (Block block : UtilKt.make(Lists.newArrayList((Iterable)ForgeRegistries.BLOCKS.getValues()), list -> list.removeIf(block -> !block.getRegistryName().func_110624_b().equals("minecraftfuture")))) {
            File json = new File("config/future-mc/generated/blockstates/" + block.getRegistryName().func_110623_a() + ".json");
            try {
                if (!json.exists()) {
                    json.createNewFile();
                }
                if (!json.canWrite()) {
                    json.setWritable(true);
                }
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                JsonObject obj = new JsonObject();
                JsonObject element = new JsonObject();
                ImmutableList states = block.func_176194_O().func_177619_a();
                for (IBlockState state : states) {
                    String[] properties = state.func_177227_a();
                    String[] names = new String[properties.size()];
                    String[] values = new String[properties.size()];
                    for (int i2 = 0; i2 < names.length; ++i2) {
                        IProperty prop = (IProperty)properties.toArray()[i2];
                        names[i2] = prop.func_177701_a();
                        values[i2] = ((Comparable)state.func_177228_b().get((Object)prop)).toString();
                    }
                    StringBuilder tagBuilder = new StringBuilder();
                    for (int i3 = 0; i3 < properties.size(); ++i3) {
                        if (i3 == properties.size() - 1) {
                            tagBuilder.append(names[i3]).append("=").append(values[i3]);
                            continue;
                        }
                        tagBuilder.append(names[i3]).append("=").append(values[i3]).append(",");
                    }
                    element.add(tagBuilder.toString(), (JsonElement)new JsonObject());
                }
                obj.add("variants", (JsonElement)element);
                String[] jsonText = gson.toJson((JsonElement)obj).split("[{]");
                for (int i4 = 0; i4 < jsonText.length; ++i4) {
                    if (jsonText[i4].endsWith("}")) continue;
                    int n = i4;
                    String string = jsonText[n] + "{";
                    jsonText[n] = string;
                    jsonText[i4] = string;
                }
                ArrayList<String[]> linesList = new ArrayList<String[]>();
                for (String line : jsonText) {
                    String[] array = line.split("},");
                    for (int i5 = 0; i5 < array.length; ++i5) {
                        if (i5 == array.length - 1) continue;
                        int n = i5;
                        String string = array[n] + "},";
                        array[n] = string;
                        array[i5] = string;
                    }
                    linesList.add(array);
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(json));
                int tabs = 0;
                Iterator iterator = linesList.iterator();
                while (iterator.hasNext()) {
                    String[] lines;
                    for (String line : lines = (String[])iterator.next()) {
                        if (line.startsWith("}")) {
                            writer.newLine();
                            --tabs;
                        } else if (line.endsWith("{")) {
                            ++tabs;
                        }
                        for (int i6 = 0; i6 < tabs; ++i6) {
                            line = "    " + line;
                        }
                        writer.write(line);
                        writer.newLine();
                    }
                }
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

