/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiPredicate;

public final class PredicateArrayList<E>
extends ArrayList<E> {
    private final BiPredicate<E, E> isEquivalent;

    public PredicateArrayList(BiPredicate<E, E> isEquivalent) {
        this.isEquivalent = isEquivalent;
    }

    public boolean containsEquivalent(E obj) {
        for (Object o : this) {
            if (!this.isEquivalent.test(o, obj)) continue;
            return true;
        }
        return false;
    }

    public void removeEquivalent(E block) {
        for (Object b : this) {
            if (!this.isEquivalent.test(block, b)) continue;
            this.remove(b);
        }
    }

    public PredicateArrayList<E> insert(E o) {
        this.add(o);
        return this;
    }

    @SafeVarargs
    public final PredicateArrayList<E> insertAll(E ... obj) {
        this.addAll(Arrays.asList(obj));
        return this;
    }
}

