/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.block.state.IBlockState;
import org.apache.logging.log4j.Level;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.entity.bee.BeeEntity;

@ZenRegister
@ZenClass(value="mods.futuremc.Bee")
public final class Bee {
    @ZenMethod
    public static void addFlower(crafttweaker.api.block.IBlockState block) {
        IBlockState state = CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)block);
        if (!BeeEntity.FLOWERS.contains(state)) {
            CraftTweakerAPI.apply((IAction)AddFlower.of(() -> BeeEntity.FLOWERS.add(state)));
        } else {
            FutureMC.LOGGER.log(Level.WARN, "Tried to add duplicate flower block to bee: " + state);
        }
    }

    @ZenMethod
    public static void removeFlower(crafttweaker.api.block.IBlockState block) {
        IBlockState state = CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)block);
        if (BeeEntity.FLOWERS.contains(state)) {
            CraftTweakerAPI.apply((IAction)RemoveFlower.of(() -> BeeEntity.FLOWERS.remove(state)));
        } else {
            FutureMC.LOGGER.log(Level.WARN, "Tried to remove non pollinateable flower block to bee " + state);
        }
    }

    @ZenMethod
    public static void clearValidFlowers() {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                BeeEntity.FLOWERS.clear();
            }

            public String describe() {
                return "Cleared pollinateable flowers";
            }
        });
    }

    private static interface RemoveFlower
    extends IAction {
        public void apply();

        public static IAction of(RemoveFlower runnable) {
            return runnable;
        }

        default public String describe() {
            return "Removed a valid flower for bee pollination";
        }
    }

    private static interface AddFlower
    extends IAction {
        public void apply();

        public static IAction of(AddFlower runnable) {
            return runnable;
        }

        default public String describe() {
            return "Added valid flower for bee pollination";
        }
    }
}

