/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import org.apache.logging.log4j.Level;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.recipe.campfire.CampfireRecipes;

@ZenRegister
@ZenClass(value="mods.futuremc.Campfire")
public final class Campfire {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, int duration) {
        if (CampfireRecipes.INSTANCE.getRecipe(CraftTweakerMC.getItemStack((IItemStack)input)) == null) {
            CraftTweakerAPI.apply((IAction)new AddRecipe(input, output, duration));
        } else {
            FutureMC.LOGGER.log(Level.WARN, "Cannot add duplicate recipe for " + input.getDefinition().getId());
        }
    }

    @ZenMethod
    public static void removeRecipe(IItemStack stack) {
        if (CampfireRecipes.INSTANCE.getRecipe(CraftTweakerMC.getItemStack((IItemStack)stack)) != null) {
            CraftTweakerAPI.apply((IAction)new RemoveRecipe(stack));
        }
    }

    @ZenMethod
    public static void clearRecipes() {
        CampfireRecipes.INSTANCE.clear();
    }

    private static class RemoveRecipe
    implements IAction {
        private final IItemStack input;

        private RemoveRecipe(IItemStack input) {
            this.input = input;
        }

        public void apply() {
            CampfireRecipes.INSTANCE.removeRecipe(CraftTweakerMC.getItemStack((IItemStack)this.input));
        }

        public String describe() {
            return "Added recipe for" + this.input.getDefinition().getId();
        }
    }

    private static class AddRecipe
    implements IAction {
        private final IItemStack input;
        private final IItemStack output;
        private final int duration;

        private AddRecipe(IItemStack input, IItemStack output, int duration) {
            this.input = input;
            this.output = output;
            this.duration = duration;
        }

        public void apply() {
            CampfireRecipes.INSTANCE.addRecipe(CraftTweakerMC.getItemStack((IItemStack)this.input), CraftTweakerMC.getItemStack((IItemStack)this.output), this.duration);
        }

        public String describe() {
            return "Added recipe for" + this.input.getDefinition().getId();
        }
    }
}

