/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.block.BlockFurnaceAdvanced;
import thedarkcolour.futuremc.recipe.furnace.SmokerRecipes;

@ZenRegister
@ZenClass(value="mods.futuremc.Smoker")
public final class Smoker {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output) {
        if (!BlockFurnaceAdvanced.FurnaceType.SMOKER.canCraft(CraftTweakerMC.getItemStack((IItemStack)input))) {
            CraftTweakerAPI.apply((IAction)new AddRecipe(input, output));
        } else {
            FutureMC.LOGGER.log(Level.WARN, "Tried to add duplicate valid Smoker input for " + input.getDefinition().getId());
        }
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        CraftTweakerAPI.apply((IAction)new RemoveRecipe(input));
    }

    @ZenMethod
    public static void clearRecipes() {
        SmokerRecipes.INSTANCE.clear();
    }

    private static final class RemoveRecipe
    implements IAction {
        private final ItemStack input;

        private RemoveRecipe(IItemStack input) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
        }

        public void apply() {
            SmokerRecipes.INSTANCE.removeRecipe(this.input);
        }

        public String describe() {
            return "Removed " + this.input.func_77973_b().getRegistryName() + " from smeltable item Smoker";
        }
    }

    private static final class AddRecipe
    implements IAction {
        private final ItemStack input;
        private final ItemStack output;

        private AddRecipe(IItemStack input, IItemStack output) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
            this.input.func_190920_e(1);
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.output.func_190920_e(1);
        }

        public void apply() {
            SmokerRecipes.INSTANCE.addRecipe(this.input, this.output);
        }

        public String describe() {
            return "Added " + this.input.func_77973_b().getRegistryName() + " to smeltable item Smoker";
        }
    }
}

