/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.entity.bee;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.core.util.ExtensionsKt;
import thedarkcolour.core.util.UtilKt;
import thedarkcolour.futuremc.entity.bee.ai.EnterHiveAI;
import thedarkcolour.futuremc.entity.bee.ai.FlyHelper;
import thedarkcolour.futuremc.entity.bee.ai.GoToFlowerAI;
import thedarkcolour.futuremc.entity.bee.ai.GoToHiveAI;
import thedarkcolour.futuremc.entity.bee.ai.LocateHiveAI;
import thedarkcolour.futuremc.entity.bee.ai.LookHelper;
import thedarkcolour.futuremc.entity.bee.ai.PollinateAI;
import thedarkcolour.futuremc.entity.bee.ai.RevengeAI;
import thedarkcolour.futuremc.entity.bee.ai.StingAI;
import thedarkcolour.futuremc.entity.bee.ai.SwarmAttackerAI;
import thedarkcolour.futuremc.entity.bee.ai.TemptAI;
import thedarkcolour.futuremc.entity.bee.ai.WanderAI;
import thedarkcolour.futuremc.registry.FBlocks;
import thedarkcolour.futuremc.registry.FSounds;
import thedarkcolour.futuremc.tile.BeeHiveTile;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u009a\u00012\u00020\u00012\u00020\u0002:\u0002\u009a\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u00101\u001a\u000202J\b\u00103\u001a\u000202H\u0014J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u0018\u00108\u001a\u0002052\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020+H\u0016J\u0006\u0010<\u001a\u000205J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u0000H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020AH\u0016J\u0010\u0010C\u001a\u00020D2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\u000e\u0010E\u001a\u0002052\u0006\u0010F\u001a\u00020\u0014J\b\u0010G\u001a\u000202H\u0014J\b\u0010H\u001a\u000205H\u0002J\u0018\u0010I\u001a\u0002022\u0006\u0010J\u001a\u00020+2\u0006\u0010K\u001a\u00020+H\u0016J\b\u0010L\u001a\u00020\u0007H\u0002J\u0010\u0010M\u001a\u0002052\u0006\u0010N\u001a\u00020\u0007H\u0002J$\u0010O\u001a\u0004\u0018\u00010\u00142\u0006\u0010P\u001a\u00020\u00072\u0012\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002050RJ\u000e\u0010S\u001a\u00020T2\u0006\u0010F\u001a\u00020\u0014J\u0010\u0010U\u001a\u00020T2\u0006\u0010V\u001a\u00020+H\u0002J\u000e\u0010W\u001a\u00020+2\u0006\u0010V\u001a\u00020+J\b\u0010X\u001a\u00020YH\u0016J\u0006\u0010Z\u001a\u00020\u0007J\n\u0010[\u001a\u0004\u0018\u00010\\H\u0014J\b\u0010]\u001a\u00020+H\u0016J\u0014\u0010^\u001a\u0004\u0018\u00010\\2\b\u0010_\u001a\u0004\u0018\u00010:H\u0014J\b\u0010`\u001a\u00020+H\u0014J\b\u0010a\u001a\u000202H\u0014J\b\u0010b\u001a\u000202H\u0014J\u0006\u0010c\u001a\u000205J\u0006\u0010d\u001a\u000205J\u0006\u0010e\u001a\u000205J\u0006\u0010f\u001a\u000205J\b\u0010g\u001a\u000202H\u0014J\u0006\u0010h\u001a\u000205J\u0010\u0010i\u001a\u0002052\u0006\u0010j\u001a\u00020kH\u0016J\u000e\u0010l\u001a\u0002052\u0006\u0010m\u001a\u00020nJ\b\u0010o\u001a\u000205H\u0002J\u0006\u0010p\u001a\u000205J\b\u0010q\u001a\u000205H\u0002J\u000e\u0010r\u001a\u0002052\u0006\u0010F\u001a\u00020\u0014J\u0018\u0010s\u001a\u0002052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010J\u001a\u00020\u0007J\b\u0010t\u001a\u000205H\u0014J\u0006\u0010u\u001a\u000202J\b\u0010v\u001a\u000202H\u0016J\b\u0010w\u001a\u000202H\u0016J\u0018\u0010x\u001a\u0002022\u0006\u0010F\u001a\u00020\u00142\u0006\u0010y\u001a\u00020zH\u0014J\u0010\u0010{\u001a\u0002022\u0006\u0010|\u001a\u00020}H\u0016J\b\u0010~\u001a\u000202H\u0002J\u0006\u0010\u007f\u001a\u000202J\u0012\u0010\u0080\u0001\u001a\u0002022\u0007\u0010\u0081\u0001\u001a\u00020\u0007H\u0002J\u0010\u0010\u0082\u0001\u001a\u0002052\u0007\u0010\u0083\u0001\u001a\u000207J\u001b\u0010\u0084\u0001\u001a\u0002022\u0007\u0010\u0085\u0001\u001a\u00020\u00072\u0007\u0010\u0086\u0001\u001a\u000205H\u0002J\u000f\u0010\u0087\u0001\u001a\u0002022\u0006\u0010e\u001a\u000205J\u0011\u0010\u0088\u0001\u001a\u0002022\u0006\u0010f\u001a\u000205H\u0002J\u0011\u0010\u0089\u0001\u001a\u0002022\u0006\u0010q\u001a\u000205H\u0002J\u0014\u0010\u008a\u0001\u001a\u0002022\t\u00106\u001a\u0005\u0018\u00010\u008b\u0001H\u0016J@\u0010\u008c\u0001\u001a\u0002022\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020T2\u0007\u0010\u0090\u0001\u001a\u00020T2\u0007\u0010\u0091\u0001\u001a\u00020T2\u0007\u0010\u0092\u0001\u001a\u00020T2\u0007\u0010\u0093\u0001\u001a\u00020TH\u0002J\t\u0010\u0094\u0001\u001a\u000202H\u0014J\t\u0010\u0095\u0001\u001a\u000202H\u0002J+\u0010\u0096\u0001\u001a\u0002022\u0007\u0010\u0097\u0001\u001a\u00020T2\u0007\u0010\u0098\u0001\u001a\u0002052\u0006\u0010m\u001a\u00020n2\u0006\u0010F\u001a\u00020\u0014H\u0014J\u0011\u0010\u0099\u0001\u001a\u0002022\u0006\u0010|\u001a\u00020}H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0010\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\t\"\u0004\b\u0012\u0010\u000bR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\t\"\u0004\b/\u0010\u000bR\u000e\u00100\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009b\u0001"}, d2={"Lthedarkcolour/futuremc/entity/bee/BeeEntity;", "Lnet/minecraft/entity/passive/EntityAnimal;", "Lnet/minecraft/entity/passive/EntityFlying;", "worldIn", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "cannotEnterHiveTicks", "", "getCannotEnterHiveTicks", "()I", "setCannotEnterHiveTicks", "(I)V", "cropsGrownSincePollination", "findFlowerCooldown", "getFindFlowerCooldown", "setFindFlowerCooldown", "findHiveCooldown", "getFindHiveCooldown", "setFindHiveCooldown", "flowerPos", "Lnet/minecraft/util/math/BlockPos;", "getFlowerPos", "()Lnet/minecraft/util/math/BlockPos;", "setFlowerPos", "(Lnet/minecraft/util/math/BlockPos;)V", "goToHiveAI", "Lthedarkcolour/futuremc/entity/bee/ai/GoToHiveAI;", "getGoToHiveAI", "()Lthedarkcolour/futuremc/entity/bee/ai/GoToHiveAI;", "setGoToHiveAI", "(Lthedarkcolour/futuremc/entity/bee/ai/GoToHiveAI;)V", "hivePos", "getHivePos", "setHivePos", "lastHurtBy", "Ljava/util/UUID;", "pollinateAI", "Lthedarkcolour/futuremc/entity/bee/ai/PollinateAI;", "getPollinateAI", "()Lthedarkcolour/futuremc/entity/bee/ai/PollinateAI;", "setPollinateAI", "(Lthedarkcolour/futuremc/entity/bee/ai/PollinateAI;)V", "rollAmount", "", "rollAmountO", "ticksSincePollination", "getTicksSincePollination", "setTicksSincePollination", "ticksSinceSting", "addCropCounter", "", "applyEntityAttributes", "attackEntityAsMob", "", "entityIn", "Lnet/minecraft/entity/Entity;", "attackEntityFrom", "source", "Lnet/minecraft/util/DamageSource;", "amount", "canEnterHive", "causeBeeDamage", "Lnet/minecraft/util/EntityDamageSource;", "entityBee", "createChild", "Lnet/minecraft/entity/EntityAgeable;", "ageable", "createNavigator", "Lnet/minecraft/pathfinding/PathNavigate;", "doesFlowerExist", "pos", "entityInit", "failedPollinatingTooLong", "fall", "distance", "damageMultiplier", "getAnger", "getBeeFlag", "i", "getBlockInRange", "range", "test", "Lkotlin/Function1;", "getBlockPathWeightD", "", "getBodyHeight", "partialTicks", "getBodyPitch", "getCreatureAttribute", "Lnet/minecraft/entity/EnumCreatureAttribute;", "getCropsGrownSincePollination", "getDeathSound", "Lnet/minecraft/util/SoundEvent;", "getEyeHeight", "getHurtSound", "damageSourceIn", "getSoundVolume", "handleJumpLava", "handleJumpWater", "hasFlower", "hasHive", "hasNectar", "hasStung", "initEntityAI", "isAngry", "isBreedingItem", "stack", "Lnet/minecraft/item/ItemStack;", "isFlowerValid", "state", "Lnet/minecraft/block/state/IBlockState;", "isHiveNearFire", "isHiveValid", "isNearTarget", "isTooFar", "isWithinDistance", "makeFlySound", "onHoneyDelivered", "onLivingUpdate", "onUpdate", "playStepSound", "blockIn", "Lnet/minecraft/block/Block;", "readEntityFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "resetCropCounter", "resetPollinationTicks", "setAnger", "anger", "setBeeAttacker", "entity", "setBeeFlag", "flag", "bool", "setHasNectar", "setHasStung", "setNearTarget", "setRevengeTarget", "Lnet/minecraft/entity/EntityLivingBase;", "spawnParticle", "particleType", "Lnet/minecraft/util/EnumParticleTypes;", "lastX", "nextX", "lastZ", "nextZ", "middle", "updateAITasks", "updateBodyPitch", "updateFallState", "y", "onGroundIn", "writeEntityToNBT", "Companion", "future-mc"})
public final class BeeEntity
extends EntityAnimal
implements EntityFlying {
    private UUID lastHurtBy;
    private float rollAmount;
    private float rollAmountO;
    private int ticksSinceSting;
    private int ticksSincePollination;
    private int cannotEnterHiveTicks;
    private int cropsGrownSincePollination;
    private int findHiveCooldown;
    private int findFlowerCooldown;
    @Nullable
    private BlockPos flowerPos;
    @Nullable
    private BlockPos hivePos;
    @Nullable
    private PollinateAI pollinateAI;
    @NotNull
    public GoToHiveAI goToHiveAI;
    private static final DataParameter<Byte> BEE_FLAGS;
    private static final DataParameter<Integer> ANGER;
    @JvmField
    @NotNull
    public static final ArrayList<IBlockState> FLOWERS;
    public static final Companion Companion;

    public final int getTicksSincePollination() {
        return this.ticksSincePollination;
    }

    public final void setTicksSincePollination(int n) {
        this.ticksSincePollination = n;
    }

    public final int getCannotEnterHiveTicks() {
        return this.cannotEnterHiveTicks;
    }

    public final void setCannotEnterHiveTicks(int n) {
        this.cannotEnterHiveTicks = n;
    }

    public final int getFindHiveCooldown() {
        return this.findHiveCooldown;
    }

    public final void setFindHiveCooldown(int n) {
        this.findHiveCooldown = n;
    }

    public final int getFindFlowerCooldown() {
        return this.findFlowerCooldown;
    }

    public final void setFindFlowerCooldown(int n) {
        this.findFlowerCooldown = n;
    }

    @Nullable
    public final BlockPos getFlowerPos() {
        return this.flowerPos;
    }

    public final void setFlowerPos(@Nullable BlockPos blockPos) {
        this.flowerPos = blockPos;
    }

    @Nullable
    public final BlockPos getHivePos() {
        return this.hivePos;
    }

    public final void setHivePos(@Nullable BlockPos blockPos) {
        this.hivePos = blockPos;
    }

    @Nullable
    public final PollinateAI getPollinateAI() {
        return this.pollinateAI;
    }

    public final void setPollinateAI(@Nullable PollinateAI pollinateAI) {
        this.pollinateAI = pollinateAI;
    }

    @NotNull
    public final GoToHiveAI getGoToHiveAI() {
        GoToHiveAI goToHiveAI = this.goToHiveAI;
        if (goToHiveAI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"goToHiveAI");
        }
        return goToHiveAI;
    }

    public final void setGoToHiveAI(@NotNull GoToHiveAI goToHiveAI) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)goToHiveAI), (String)"<set-?>");
        this.goToHiveAI = goToHiveAI;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BEE_FLAGS, (Object)((byte)0));
        this.field_70180_af.func_187214_a(ANGER, (Object)0);
    }

    public final double getBlockPathWeightD(@NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        World world = this.field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        return ExtensionsKt.isAir((IBlockAccess)world, pos) ? 10.0 : 0.0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new StingAI(this, 1.4f, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EnterHiveAI(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new TemptAI(this));
        PollinateAI pollinateAI = this.pollinateAI = new PollinateAI(this);
        if (pollinateAI == null) {
            Intrinsics.throwNpe();
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)pollinateAI);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new LocateHiveAI(this));
        GoToHiveAI goToHiveAI = this.goToHiveAI = new GoToHiveAI(this);
        if (goToHiveAI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"goToHiveAI");
        }
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)goToHiveAI);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new GoToFlowerAI(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new WanderAI(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new RevengeAI(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new SwarmAttackerAI(this));
    }

    public final boolean doesFlowerExist(@NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        IBlockState iBlockState = this.field_70170_p.func_180495_p(pos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos)");
        return this.isFlowerValid(iBlockState);
    }

    public void func_70014_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_70014_b(compound);
        if (this.hasHive()) {
            compound.func_74782_a("HivePos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.hivePos));
        }
        if (this.hasFlower()) {
            compound.func_74782_a("FlowerPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.flowerPos));
        }
        compound.func_74757_a("HasNectar", this.hasNectar());
        compound.func_74757_a("HasStung", this.hasStung());
        compound.func_74768_a("TicksSincePollination", this.ticksSincePollination);
        compound.func_74768_a("CannotEnterHiveTicks", this.cannotEnterHiveTicks);
        compound.func_74768_a("CropsGrownSincePollination", this.cropsGrownSincePollination);
        compound.func_74768_a("Anger", this.getAnger());
        if (this.lastHurtBy != null) {
            compound.func_74778_a("HurtBy", String.valueOf(this.lastHurtBy));
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    public void func_70037_a(@NotNull NBTTagCompound compound) {
        String s;
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        this.hivePos = compound.func_74764_b("HivePos") ? NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("HivePos")) : null;
        this.flowerPos = compound.func_74764_b("FlowerPos") ? NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("FlowerPos")) : null;
        super.func_70037_a(compound);
        this.setHasNectar(compound.func_74767_n("HasNectar"));
        this.setHasStung(compound.func_74767_n("HasStung"));
        this.setAnger(compound.func_74762_e("Anger"));
        this.ticksSincePollination = compound.func_74762_e("TicksSincePollination");
        this.cannotEnterHiveTicks = compound.func_74762_e("CannotEnterHiveTicks");
        this.cropsGrownSincePollination = compound.func_74762_e("CropsGrownSincePollination");
        String string = s = compound.func_74779_i("HurtBy");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"s");
        CharSequence charSequence = string;
        boolean bl = false;
        if (charSequence.length() > 0) {
            UUID uUID = this.lastHurtBy = UUID.fromString(s);
            if (uUID == null) {
                Intrinsics.throwNpe();
            }
            EntityPlayer player = this.field_70170_p.func_152378_a(uUID);
            this.func_70604_c((EntityLivingBase)player);
            if (player != null) {
                this.field_70717_bb = player;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    public boolean func_70652_k(@NotNull Entity entityIn) {
        Intrinsics.checkParameterIsNotNull((Object)entityIn, (String)"entityIn");
        DamageSource damageSource = (DamageSource)this.causeBeeDamage(this);
        IAttributeInstance iAttributeInstance = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance, (String)"this.getEntityAttribute(\u2026Attributes.ATTACK_DAMAGE)");
        boolean flag = entityIn.func_70097_a(damageSource, (float)iAttributeInstance.func_111126_e());
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
            if (entityIn instanceof EntityLivingBase) {
                int duration = 0;
                World world = this.field_70170_p;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                if (world.func_175659_aa() == EnumDifficulty.NORMAL) {
                    duration = 10;
                } else {
                    World world2 = this.field_70170_p;
                    Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
                    if (world2.func_175659_aa() == EnumDifficulty.HARD) {
                        duration = 18;
                    }
                }
                if (duration > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration * 20, 0));
                }
            }
            this.setHasStung(true);
            this.func_70624_b(null);
            this.func_184185_a(FSounds.BEE_STING, 1.0f, 1.0f);
        }
        return flag;
    }

    private final EntityDamageSource causeBeeDamage(BeeEntity entityBee) {
        return new EntityDamageSource("sting", (Entity)entityBee);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateBodyPitch();
    }

    private final void spawnParticle(EnumParticleTypes particleType, double lastX, double nextX, double lastZ, double nextZ, double middle) {
        this.field_70170_p.func_175688_a(particleType, UtilKt.lerp(this.field_70146_Z.nextDouble(), lastX, nextX), middle, UtilKt.lerp(this.field_70146_Z.nextDouble(), lastX, lastZ), 0.0, 0.0, 0.0, new int[0]);
    }

    public final boolean hasFlower() {
        return this.flowerPos != null;
    }

    private final double getBodyHeight(float partialTicks) {
        return this.field_70163_u + (double)(this.field_70131_O * partialTicks);
    }

    private final boolean failedPollinatingTooLong() {
        return this.ticksSincePollination > 3600;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canEnterHive() {
        if (this.cannotEnterHiveTicks > 0) return false;
        PollinateAI pollinateAI = this.pollinateAI;
        if (pollinateAI == null) {
            Intrinsics.throwNpe();
        }
        if (pollinateAI.isRunning()) return false;
        if (this.hasStung()) return false;
        if (!this.hasNectar() && !this.failedPollinatingTooLong()) {
            World world = this.field_70170_p;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
            if (!world.func_72896_J()) {
                World world2 = this.field_70170_p;
                Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
                if (world2.func_72935_r()) return false;
            }
        }
        boolean bl = true;
        boolean flag = bl;
        if (!flag) return false;
        if (this.isHiveNearFire()) return false;
        return true;
    }

    public final float getBodyPitch(float partialTicks) {
        return UtilKt.lerp(partialTicks, this.rollAmountO, this.rollAmount);
    }

    private final void updateBodyPitch() {
        float f;
        BeeEntity beeEntity;
        this.rollAmountO = this.rollAmount;
        BeeEntity beeEntity2 = this;
        if (this.isNearTarget()) {
            float f2 = 1.0f;
            float f3 = this.rollAmount + 0.2f;
            BeeEntity beeEntity3 = beeEntity2;
            boolean bl = false;
            float f4 = Math.min(f2, f3);
            beeEntity = beeEntity3;
            f = f4;
        } else {
            float f5 = 0.0f;
            float f6 = this.rollAmount - 0.2f;
            BeeEntity beeEntity4 = beeEntity2;
            boolean bl = false;
            float f7 = Math.max(f5, f6);
            beeEntity = beeEntity4;
            f = f7;
        }
        beeEntity.rollAmount = f;
    }

    public void func_70604_c(@Nullable EntityLivingBase entityIn) {
        super.func_70604_c(entityIn);
        if (entityIn != null) {
            this.lastHurtBy = entityIn.func_110124_au();
        }
    }

    protected void func_70619_bc() {
        if (this.hasStung()) {
            BeeEntity beeEntity = this;
            ++beeEntity.ticksSinceSting;
            int cfr_ignored_0 = beeEntity.ticksSinceSting;
            if (this.ticksSinceSting % 5 == 0 && this.field_70146_Z.nextInt(MathHelper.func_76125_a((int)(1200 - this.ticksSinceSting), (int)1, (int)1200)) == 0) {
                DamageSource damageSource = DamageSource.field_76377_j;
                Intrinsics.checkExpressionValueIsNotNull((Object)damageSource, (String)"DamageSource.GENERIC");
                this.func_70097_a(damageSource, this.func_110143_aJ());
            }
        }
        if (this.isAngry()) {
            int anger = this.getAnger();
            EntityLivingBase livingEntity = this.func_70638_az();
            this.setAnger(anger - 1);
            if (anger == 0 && livingEntity != null) {
                this.setBeeAttacker((Entity)livingEntity);
            }
        }
        if (!this.hasNectar()) {
            BeeEntity beeEntity = this;
            ++beeEntity.ticksSincePollination;
            int cfr_ignored_1 = beeEntity.ticksSincePollination;
        }
    }

    public final void resetPollinationTicks() {
        this.ticksSincePollination = 0;
    }

    private final boolean isHiveNearFire() {
        boolean bl;
        if (this.hasHive()) {
            bl = false;
        } else {
            BlockPos blockPos = this.hivePos;
            if (blockPos == null) {
                return false;
            }
            TileEntity hive = this.field_70170_p.func_175625_s(blockPos);
            bl = hive instanceof BeeHiveTile && ((BeeHiveTile)hive).isNearFire();
        }
        return bl;
    }

    public final boolean isAngry() {
        return this.getAnger() > 0;
    }

    private final int getAnger() {
        Object object = this.field_70180_af.func_187225_a(ANGER);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dataManager.get(ANGER)");
        return ((Number)object).intValue();
    }

    private final void setAnger(int anger) {
        this.field_70180_af.func_187227_b(ANGER, (Object)anger);
    }

    public final boolean hasHive() {
        return this.hivePos != null;
    }

    public final int getCropsGrownSincePollination() {
        return this.cropsGrownSincePollination;
    }

    private final void resetCropCounter() {
        this.cropsGrownSincePollination = 0;
    }

    public final void addCropCounter() {
        BeeEntity beeEntity = this;
        ++beeEntity.cropsGrownSincePollination;
        int cfr_ignored_0 = beeEntity.cropsGrownSincePollination;
    }

    /*
     * Unable to fully structure code
     */
    public void func_70636_d() {
        block7: {
            super.func_70636_d();
            if (this.field_70170_p.field_72995_K) break block7;
            if (this.cannotEnterHiveTicks > 0) {
                v0 = this;
                v0.cannotEnterHiveTicks += -1;
                v0.cannotEnterHiveTicks;
            }
            if (this.findHiveCooldown > 0) {
                v1 = this;
                v1.findHiveCooldown += -1;
                v1.findHiveCooldown;
            }
            if (this.findFlowerCooldown > 0) {
                v2 = this;
                v2.findFlowerCooldown += -1;
                v2.findFlowerCooldown;
            }
            if (!this.isAngry() || this.hasStung() || this.func_70638_az() == null) ** GOTO lbl-1000
            v3 = this.func_70638_az();
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            if (v3.func_70068_e((Entity)this) < 4.0) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            this.setNearTarget(v4);
            if (this.hasHive() && this.field_70173_aa % 20 == 0 && !this.isHiveValid()) {
                this.hivePos = null;
            }
        }
    }

    public final boolean hasNectar() {
        return this.getBeeFlag(8);
    }

    public final void setHasNectar(boolean hasNectar) {
        this.setBeeFlag(8, hasNectar);
    }

    public final boolean hasStung() {
        return this.getBeeFlag(4);
    }

    private final void setHasStung(boolean hasStung) {
        this.setBeeFlag(4, hasStung);
    }

    private final boolean isNearTarget() {
        return this.getBeeFlag(2);
    }

    private final void setNearTarget(boolean isNearTarget) {
        this.setBeeFlag(2, isNearTarget);
    }

    public final boolean isTooFar(@NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return !this.isWithinDistance(pos, 48);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isHiveValid() {
        if (!this.hasHive()) return false;
        BlockPos blockPos = this.hivePos;
        if (blockPos == null) {
            Intrinsics.throwNpe();
        }
        if (!(this.field_70170_p.func_175625_s(blockPos) instanceof BeeHiveTile)) return false;
        return true;
    }

    private final void setBeeFlag(int flag, boolean bool) {
        Byte b = (Byte)this.field_70180_af.func_187225_a(BEE_FLAGS);
        if (bool) {
            Byte by = b;
            Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"b");
            byte by2 = by;
            byte by3 = (byte)flag;
            DataParameter<Byte> dataParameter = BEE_FLAGS;
            EntityDataManager entityDataManager = this.field_70180_af;
            boolean bl = false;
            byte by4 = (byte)(by2 | by3);
            entityDataManager.func_187227_b(dataParameter, (Object)by4);
        } else {
            Byte by = b;
            Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"b");
            byte by5 = by;
            byte by6 = (byte)(~flag);
            DataParameter<Byte> dataParameter = BEE_FLAGS;
            EntityDataManager entityDataManager = this.field_70180_af;
            boolean bl = false;
            byte by7 = (byte)(by5 & by6);
            entityDataManager.func_187227_b(dataParameter, (Object)by7);
        }
    }

    private final boolean getBeeFlag(int i2) {
        return (((Number)this.field_70180_af.func_187225_a(BEE_FLAGS)).byteValue() & i2) != 0;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        IAttributeInstance iAttributeInstance = this.func_110148_a(SharedMonsterAttributes.field_111267_a);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance, (String)"getEntityAttribute(Share\u2026terAttributes.MAX_HEALTH)");
        iAttributeInstance.func_111128_a(10.0);
        IAttributeInstance iAttributeInstance2 = this.func_110148_a(SharedMonsterAttributes.field_193334_e);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance2, (String)"getEntityAttribute(Share\u2026rAttributes.FLYING_SPEED)");
        iAttributeInstance2.func_111128_a((double)0.6f);
        IAttributeInstance iAttributeInstance3 = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance3, (String)"getEntityAttribute(Share\u2026ttributes.MOVEMENT_SPEED)");
        iAttributeInstance3.func_111128_a((double)0.3f);
        IAttributeInstance iAttributeInstance4 = this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance4, (String)"attributeMap.registerAtt\u2026Attributes.ATTACK_DAMAGE)");
        iAttributeInstance4.func_111128_a(2.0);
    }

    @NotNull
    protected PathNavigate func_175447_b(@NotNull World worldIn) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        PathNavigateFlying navigateFlying2 = new PathNavigateFlying(this, worldIn, (EntityLiving)this, worldIn){
            final /* synthetic */ BeeEntity this$0;
            final /* synthetic */ World $worldIn;

            public boolean func_188555_b(@NotNull BlockPos pos) {
                Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                return !this.$worldIn.func_175623_d(pos.func_177977_b());
            }

            public void func_75501_e() {
                PollinateAI pollinateAI = this.this$0.getPollinateAI();
                if (pollinateAI == null) {
                    Intrinsics.throwNpe();
                }
                if (!pollinateAI.isRunning()) {
                    super.func_75501_e();
                }
            }
            {
                this.this$0 = $outer;
                this.$worldIn = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
        navigateFlying2.func_192879_a(false);
        navigateFlying2.func_192878_b(true);
        navigateFlying2.func_192877_c(false);
        return (PathNavigate)navigateFlying2;
    }

    public boolean func_70877_b(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        IBlockState iBlockState = Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77960_j());
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"Block.getBlockFromItem(s\u2026eFromMeta(stack.metadata)");
        return this.isFlowerValid(iBlockState);
    }

    public final boolean isFlowerValid(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return FLOWERS.contains(state);
    }

    protected void func_180429_a(@NotNull BlockPos pos, @NotNull Block blockIn) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)blockIn, (String)"blockIn");
    }

    @Nullable
    protected SoundEvent func_184601_bQ(@Nullable DamageSource damageSourceIn) {
        return FSounds.BEE_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return FSounds.BEE_DEATH;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Nullable
    public EntityAgeable func_90011_a(@NotNull EntityAgeable ageable) {
        Intrinsics.checkParameterIsNotNull((Object)ageable, (String)"ageable");
        World world = this.field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        return (EntityAgeable)new BeeEntity(world);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, @NotNull IBlockState state, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public final void onHoneyDelivered() {
        this.setHasNectar(false);
        this.resetCropCounter();
    }

    public final boolean setBeeAttacker(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.setAnger(400 + this.field_70146_Z.nextInt(400));
        if (entity instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)entity);
        }
        return true;
    }

    public boolean func_70097_a(@NotNull DamageSource source, float amount) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (this.func_180431_b(source)) {
            bl = false;
        } else {
            Entity attacker = source.func_76346_g();
            if (attacker instanceof EntityPlayer && !((EntityPlayer)attacker).func_184812_l_() && this.func_70685_l(attacker)) {
                PollinateAI pollinateAI = this.pollinateAI;
                if (pollinateAI != null) {
                    pollinateAI.setRunning(false);
                }
                this.setBeeAttacker(attacker);
            }
            bl = super.func_70097_a(source, amount);
        }
        return bl;
    }

    @NotNull
    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected void func_70629_bd() {
        this.field_70181_x += 0.01;
    }

    protected void func_180466_bG() {
        this.field_70181_x += 0.01;
    }

    public final boolean isWithinDistance(@Nullable BlockPos flowerPos, int distance) {
        BlockPos blockPos = flowerPos;
        if (blockPos == null) {
            return false;
        }
        return blockPos.func_177951_i((Vec3i)this.func_180425_c()) < (double)(distance * distance);
    }

    @Nullable
    public final BlockPos getBlockInRange(int range, @NotNull Function1<? super BlockPos, Boolean> test) {
        Intrinsics.checkParameterIsNotNull(test, (String)"test");
        Iterator iterator = BlockPos.func_177975_b((BlockPos)this.func_180425_c().func_177982_a(-range, -range, -range), (BlockPos)this.func_180425_c().func_177982_a(range, range, range)).iterator();
        while (iterator.hasNext()) {
            BlockPos.MutableBlockPos pos;
            BlockPos.MutableBlockPos mutableBlockPos = pos = (BlockPos.MutableBlockPos)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)mutableBlockPos, (String)"pos");
            if (!((Boolean)test.invoke((Object)mutableBlockPos)).booleanValue()) continue;
            return pos.func_185334_h();
        }
        return null;
    }

    public BeeEntity(@NotNull World worldIn) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        super(worldIn);
        this.field_70765_h = new FlyHelper(this);
        this.field_70749_g = new LookHelper(this);
        this.func_70105_a(0.7f, 0.7f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    static {
        Companion = new Companion(null);
        BEE_FLAGS = EntityDataManager.func_187226_a(BeeEntity.class, (DataSerializer)DataSerializers.field_187191_a);
        ANGER = EntityDataManager.func_187226_a(BeeEntity.class, (DataSerializer)DataSerializers.field_187192_b);
        Object[] objectArray = new IBlockState[13];
        objectArray[0] = FBlocks.INSTANCE.getCORNFLOWER().func_176223_P();
        objectArray[1] = FBlocks.INSTANCE.getLILY_OF_THE_VALLEY().func_176223_P();
        objectArray[2] = FBlocks.INSTANCE.getWITHER_ROSE().func_176223_P();
        BlockFlower blockFlower = Blocks.field_150327_N;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower, (String)"Blocks.YELLOW_FLOWER");
        IBlockState iBlockState = blockFlower.func_176223_P();
        BlockFlower blockFlower2 = Blocks.field_150327_N;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower2, (String)"Blocks.YELLOW_FLOWER");
        objectArray[3] = iBlockState.func_177226_a(blockFlower2.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.DANDELION);
        BlockFlower blockFlower3 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower3, (String)"Blocks.RED_FLOWER");
        IBlockState iBlockState2 = blockFlower3.func_176223_P();
        BlockFlower blockFlower4 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower4, (String)"Blocks.RED_FLOWER");
        objectArray[4] = iBlockState2.func_177226_a(blockFlower4.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.POPPY);
        BlockFlower blockFlower5 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower5, (String)"Blocks.RED_FLOWER");
        IBlockState iBlockState3 = blockFlower5.func_176223_P();
        BlockFlower blockFlower6 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower6, (String)"Blocks.RED_FLOWER");
        objectArray[5] = iBlockState3.func_177226_a(blockFlower6.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.BLUE_ORCHID);
        BlockFlower blockFlower7 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower7, (String)"Blocks.RED_FLOWER");
        IBlockState iBlockState4 = blockFlower7.func_176223_P();
        BlockFlower blockFlower8 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower8, (String)"Blocks.RED_FLOWER");
        objectArray[6] = iBlockState4.func_177226_a(blockFlower8.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.ALLIUM);
        BlockFlower blockFlower9 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower9, (String)"Blocks.RED_FLOWER");
        IBlockState iBlockState5 = blockFlower9.func_176223_P();
        BlockFlower blockFlower10 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower10, (String)"Blocks.RED_FLOWER");
        objectArray[7] = iBlockState5.func_177226_a(blockFlower10.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.HOUSTONIA);
        BlockFlower blockFlower11 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower11, (String)"Blocks.RED_FLOWER");
        IBlockState iBlockState6 = blockFlower11.func_176223_P();
        BlockFlower blockFlower12 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower12, (String)"Blocks.RED_FLOWER");
        objectArray[8] = iBlockState6.func_177226_a(blockFlower12.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.RED_TULIP);
        BlockFlower blockFlower13 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower13, (String)"Blocks.RED_FLOWER");
        IBlockState iBlockState7 = blockFlower13.func_176223_P();
        BlockFlower blockFlower14 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower14, (String)"Blocks.RED_FLOWER");
        objectArray[9] = iBlockState7.func_177226_a(blockFlower14.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.ORANGE_TULIP);
        BlockFlower blockFlower15 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower15, (String)"Blocks.RED_FLOWER");
        IBlockState iBlockState8 = blockFlower15.func_176223_P();
        BlockFlower blockFlower16 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower16, (String)"Blocks.RED_FLOWER");
        objectArray[10] = iBlockState8.func_177226_a(blockFlower16.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.WHITE_TULIP);
        BlockFlower blockFlower17 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower17, (String)"Blocks.RED_FLOWER");
        IBlockState iBlockState9 = blockFlower17.func_176223_P();
        BlockFlower blockFlower18 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower18, (String)"Blocks.RED_FLOWER");
        objectArray[11] = iBlockState9.func_177226_a(blockFlower18.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.PINK_TULIP);
        BlockFlower blockFlower19 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower19, (String)"Blocks.RED_FLOWER");
        IBlockState iBlockState10 = blockFlower19.func_176223_P();
        BlockFlower blockFlower20 = Blocks.field_150328_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockFlower20, (String)"Blocks.RED_FLOWER");
        objectArray[12] = iBlockState10.func_177226_a(blockFlower20.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.OXEYE_DAISY);
        FLOWERS = CollectionsKt.arrayListOf((Object[])objectArray);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\t\u001a\"\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b0\nj\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b`\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lthedarkcolour/futuremc/entity/bee/BeeEntity$Companion;", "", "()V", "ANGER", "Lnet/minecraft/network/datasync/DataParameter;", "", "kotlin.jvm.PlatformType", "BEE_FLAGS", "", "FLOWERS", "Ljava/util/ArrayList;", "Lnet/minecraft/block/state/IBlockState;", "Lkotlin/collections/ArrayList;", "future-mc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

