/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.entity.bee.ai;

import java.util.Random;
import java.util.function.ToDoubleFunction;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.core.util.ExtensionsKt;
import thedarkcolour.futuremc.entity.bee.BeeEntity;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lthedarkcolour/futuremc/entity/bee/ai/WanderAI;", "Lnet/minecraft/entity/ai/EntityAIBase;", "bee", "Lthedarkcolour/futuremc/entity/bee/BeeEntity;", "(Lthedarkcolour/futuremc/entity/bee/BeeEntity;)V", "getRandomLocation", "Lnet/minecraft/util/math/Vec3d;", "shouldContinueExecuting", "", "shouldExecute", "startExecuting", "", "Companion", "future-mc"})
public final class WanderAI
extends EntityAIBase {
    private final BeeEntity bee;
    public static final Companion Companion = new Companion(null);

    public boolean func_75250_a() {
        return this.bee.func_70661_as().func_75500_f() && this.bee.func_70681_au().nextInt(10) == 0;
    }

    public boolean func_75253_b() {
        return !this.bee.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        Vec3d vec3d = this.getRandomLocation();
        if (vec3d != null) {
            this.bee.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
        }
    }

    private final Vec3d getRandomLocation() {
        Vec3d vec3d;
        if (this.bee.isHiveValid() && !this.bee.isWithinDistance(this.bee.getHivePos(), 40)) {
            BlockPos blockPos = this.bee.getHivePos();
            if (blockPos == null) {
                Intrinsics.throwNpe();
            }
            Vec3d vec3d1 = new Vec3d((Vec3i)blockPos);
            vec3d = vec3d1.func_178788_d(this.bee.func_174791_d()).func_72432_b();
        } else {
            vec3d = this.bee.func_70676_i(0.0f);
        }
        Vec3d vec3d2 = vec3d;
        EntityCreature entityCreature = (EntityCreature)this.bee;
        Vec3d vec3d3 = vec3d2;
        Intrinsics.checkExpressionValueIsNotNull((Object)vec3d3, (String)"vec3d");
        Vec3d vec3d22 = Companion.findAirTarget(entityCreature, 8, 7, vec3d3, 1.5707963267948966, 2, 1);
        Vec3d vec3d4 = vec3d22;
        if (vec3d4 == null) {
            vec3d4 = Companion.findGroundTarget((EntityCreature)this.bee, 8, 4, -2, vec3d2, 1.5707963267948966);
        }
        return vec3d4;
    }

    public WanderAI(@NotNull BeeEntity bee) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)bee), (String)"bee");
        this.bee = bee;
        this.func_75248_a(1);
    }

    @JvmStatic
    @Nullable
    public static final Vec3d findAirTarget(@NotNull EntityCreature bee, int i2, int i1, @NotNull Vec3d vec3d, double d, int i22, int i3) {
        return Companion.findAirTarget(bee, i2, i1, vec3d, d, i22, i3);
    }

    @JvmStatic
    @Nullable
    public static final Vec3d findGroundTarget(@NotNull EntityCreature bee, int i2, int i1, int i22, @NotNull Vec3d vec3d, double d) {
        return Companion.findGroundTarget(bee, i2, i1, i22, vec3d, d);
    }

    @JvmStatic
    @Nullable
    public static final Vec3d findGroundTargetTowards(@NotNull EntityCreature bee, int xz, int y, int i2, @NotNull Vec3d vector, double d) {
        return Companion.findGroundTargetTowards(bee, xz, y, i2, vector, d);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0007J:\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J:\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007Jp\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J4\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\b2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00180#H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010%\u001a\u00020&H\u0002J<\u0010'\u001a\u0004\u0018\u00010\u001b2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006*"}, d2={"Lthedarkcolour/futuremc/entity/bee/ai/WanderAI$Companion;", "", "()V", "findAirTarget", "Lnet/minecraft/util/math/Vec3d;", "bee", "Lnet/minecraft/entity/EntityCreature;", "i", "", "i1", "vec3d", "d", "", "i2", "i3", "findGroundTarget", "findGroundTargetTowards", "xz", "y", "vector", "findTarget", "i0", "i4", "b", "", "toDoubleFunction", "Ljava/util/function/ToDoubleFunction;", "Lnet/minecraft/util/math/BlockPos;", "b1", "b2", "findValidPositionAbove", "previous", "aboveSolidAmount", "heightLimit", "condition", "Lkotlin/Function1;", "getBlockPathWeightD", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "getRandomOffset", "rand", "Ljava/util/Random;", "future-mc"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Vec3d findAirTarget(@NotNull EntityCreature bee, int i2, int i1, @NotNull Vec3d vec3d, double d, int i22, int i3) {
            Intrinsics.checkParameterIsNotNull((Object)bee, (String)"bee");
            Intrinsics.checkParameterIsNotNull((Object)vec3d, (String)"vec3d");
            return this.findTarget(bee, i2, i1, 0, vec3d, false, d, this.getBlockPathWeightD((EntityLivingBase)bee), true, i22, i3, true);
        }

        @JvmStatic
        @Nullable
        public final Vec3d findGroundTarget(@NotNull EntityCreature bee, int i2, int i1, int i22, @NotNull Vec3d vec3d, double d) {
            Intrinsics.checkParameterIsNotNull((Object)bee, (String)"bee");
            Intrinsics.checkParameterIsNotNull((Object)vec3d, (String)"vec3d");
            return this.findTarget(bee, i2, i1, i22, vec3d, true, d, this.getBlockPathWeightD((EntityLivingBase)bee), true, 0, 0, false);
        }

        @JvmStatic
        @Nullable
        public final Vec3d findGroundTargetTowards(@NotNull EntityCreature bee, int xz, int y, int i2, @NotNull Vec3d vector, double d) {
            Vec3d vec3d;
            Intrinsics.checkParameterIsNotNull((Object)bee, (String)"bee");
            Intrinsics.checkParameterIsNotNull((Object)vector, (String)"vector");
            Vec3d vec3d2 = vec3d = vector.func_178786_a(bee.field_70165_t, bee.field_70163_u, bee.field_70161_v);
            Intrinsics.checkExpressionValueIsNotNull((Object)vec3d2, (String)"vec3d");
            return this.findTarget(bee, xz, y, i2, vec3d2, false, d, this.getBlockPathWeightD((EntityLivingBase)bee), true, 0, 0, false);
        }

        /*
         * WARNING - void declaration
         */
        private final Vec3d findTarget(EntityCreature bee, int i0, int i1, int i4, Vec3d vec3d, boolean b, double d, ToDoubleFunction<BlockPos> toDoubleFunction, boolean b1, int i2, int i3, boolean b2) {
            boolean bl;
            PathNavigate navigator = bee.func_70661_as();
            Random rand = bee.func_70681_au();
            if (bee.func_110174_bM() != -1.0f) {
                BlockPos blockPos = bee.func_180486_cf();
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"bee.homePosition");
                Vec3i vec3i = (Vec3i)blockPos;
                Vec3d vec3d2 = bee.func_174791_d();
                Intrinsics.checkExpressionValueIsNotNull((Object)vec3d2, (String)"bee.positionVector");
                bl = ExtensionsKt.isInRange(vec3i, vec3d2, (double)(bee.func_110174_bM() + (float)i0) + 1.0);
            } else {
                bl = false;
            }
            boolean flag = bl;
            boolean flag1 = false;
            double d0 = DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY();
            BlockPos pos = new BlockPos((Entity)bee);
            int n = 0;
            int n2 = 9;
            while (n <= n2) {
                void i5;
                block9: {
                    double d1;
                    BlockPos pos3;
                    block10: {
                        Random random = rand;
                        Intrinsics.checkExpressionValueIsNotNull((Object)random, (String)"rand");
                        BlockPos pos1 = this.getRandomOffset(random, i0, i1, i4, vec3d, d);
                        if (pos1 == null) break block9;
                        int j = pos1.func_177958_n();
                        int k = pos1.func_177956_o();
                        int l = pos1.func_177952_p();
                        if (bee.func_110174_bM() != -1.0f && i0 > 1) {
                            BlockPos pos2 = bee.func_180486_cf();
                            double d2 = bee.field_70165_t;
                            BlockPos blockPos = pos2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos2");
                            j = d2 > (double)blockPos.func_177958_n() ? (j -= rand.nextInt(i0 / 2)) : (j += rand.nextInt(i0 / 2));
                            l = bee.field_70161_v > (double)pos2.func_177952_p() ? (l -= rand.nextInt(i0 / 2)) : (l += rand.nextInt(i0 / 2));
                        }
                        pos3 = new BlockPos((double)j + bee.field_70165_t, (double)k + bee.field_70163_u, (double)l + bee.field_70161_v);
                        World world = bee.field_70170_p;
                        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"bee.world");
                        int n3 = pos3.func_177956_o();
                        if (0 > n3 || world.func_72800_K() < n3 || flag && !bee.func_180485_d(pos3) || b2 && !navigator.func_188555_b(pos3)) break block9;
                        if (b1) {
                            int n4 = rand.nextInt(i2 + 1) + i3;
                            World world2 = bee.field_70170_p;
                            Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"bee.world");
                            pos3 = this.findValidPositionAbove(pos3, n4, world2.func_72800_K(), (Function1<? super BlockPos, Boolean>)((Function1)new Function1<BlockPos, Boolean>(bee){
                                final /* synthetic */ EntityCreature $bee;

                                public final boolean invoke(@NotNull BlockPos pos4) {
                                    Intrinsics.checkParameterIsNotNull((Object)pos4, (String)"pos4");
                                    IBlockState iBlockState = this.$bee.field_70170_p.func_180495_p(pos4);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"bee.world.getBlockState(pos4)");
                                    Material material = iBlockState.func_185904_a();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"bee.world.getBlockState(pos4).material");
                                    return material.func_76220_a();
                                }
                                {
                                    this.$bee = entityCreature;
                                    super(1);
                                }
                            }));
                        }
                        if (b) break block10;
                        IBlockState iBlockState = bee.field_70170_p.func_180495_p(pos3);
                        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"bee.world.getBlockState(pos3)");
                        if (!(Intrinsics.areEqual((Object)iBlockState.func_185904_a(), (Object)Material.field_151586_h) ^ true)) break block9;
                    }
                    PathNavigate pathNavigate = navigator;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pathNavigate, (String)"navigator");
                    PathNodeType node = pathNavigate.func_189566_q().func_186330_a((IBlockAccess)bee.field_70170_p, pos3.func_177958_n(), pos3.func_177956_o(), pos3.func_177952_p());
                    if (bee.func_184643_a(node) == 0.0f && (d1 = toDoubleFunction.applyAsDouble(pos3)) > d0) {
                        d0 = d1;
                        pos = pos3;
                        flag1 = true;
                    }
                }
                ++i5;
            }
            return flag1 ? new Vec3d((Vec3i)pos) : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final BlockPos getRandomOffset(Random rand, int i0, int i1, int i2, Vec3d vec3d, double d) {
            BlockPos blockPos;
            if (vec3d != null && d < Math.PI) {
                double d3 = MathHelper.func_181159_b((double)vec3d.field_72449_c, (double)vec3d.field_72450_a) - (double)1.5707964f;
                double d4 = d3 + (double)(2.0f * rand.nextFloat() - 1.0f) * d;
                double d2 = rand.nextDouble();
                boolean bl = false;
                double d0 = Math.sqrt(d2) * (double)MathHelper.field_180189_a * (double)i0;
                double d5 = -d0;
                bl = false;
                double d6 = Math.sin(d4);
                double d1 = d5 * d6;
                d5 = d0;
                boolean bl2 = false;
                d6 = Math.cos(d4);
                double d22 = d5 * d6;
                bl2 = false;
                if (!(Math.abs(d1) <= (double)i0)) return null;
                bl2 = false;
                if (!(Math.abs(d22) <= (double)i0)) return null;
                int l = rand.nextInt(2 * i1 + 1) - i1 + i2;
                blockPos = new BlockPos(d1, (double)l, d22);
                return blockPos;
            } else {
                int i3 = rand.nextInt(2 * i0 + 1) - i0;
                int j = rand.nextInt(2 * i1 + 1) - i1 + i2;
                int k = rand.nextInt(2 * i0 + 1) - i0;
                blockPos = new BlockPos(i3, j, k);
            }
            return blockPos;
        }

        private final BlockPos findValidPositionAbove(BlockPos previous, int aboveSolidAmount, int heightLimit, Function1<? super BlockPos, Boolean> condition) {
            boolean bl = aboveSolidAmount < 0;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-WanderAI$Companion$findValidPositionAbove$22 = false;
                String $i$a$-assert-WanderAI$Companion$findValidPositionAbove$22 = "aboveSolidAmount was " + aboveSolidAmount + ", expected >= 0";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-WanderAI$Companion$findValidPositionAbove$22));
            }
            if (!((Boolean)condition.invoke((Object)previous)).booleanValue()) {
                return previous;
            }
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(previous).func_189536_c(EnumFacing.UP);
            while (true) {
                BlockPos.MutableBlockPos mutableBlockPos = pos;
                Intrinsics.checkExpressionValueIsNotNull((Object)mutableBlockPos, (String)"pos");
                if (mutableBlockPos.func_177956_o() >= heightLimit || !((Boolean)condition.invoke((Object)pos)).booleanValue()) break;
                pos.func_189536_c(EnumFacing.UP);
            }
            BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos((BlockPos)pos);
            BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos((BlockPos)pos1);
            while (pos1.func_177956_o() < heightLimit && pos1.func_177956_o() - pos.func_177956_o() < aboveSolidAmount) {
                pos2.func_189536_c(EnumFacing.UP);
                if (((Boolean)condition.invoke((Object)pos2)).booleanValue()) break;
                pos1.func_189533_g((Vec3i)pos2);
            }
            BlockPos blockPos = pos1.func_185334_h();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos1.toImmutable()");
            return blockPos;
        }

        private final ToDoubleFunction<BlockPos> getBlockPathWeightD(EntityLivingBase entity) {
            return new ToDoubleFunction<BlockPos>(entity){
                final /* synthetic */ EntityLivingBase $entity;

                public final double applyAsDouble(BlockPos pos) {
                    World world = this.$entity.field_70170_p;
                    Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"entity.world");
                    IBlockAccess iBlockAccess = (IBlockAccess)world;
                    BlockPos blockPos = pos;
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
                    return ExtensionsKt.isAir(iBlockAccess, blockPos) ? 10.0 : 0.0;
                }
                {
                    this.$entity = entityLivingBase;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

