/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.client.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProgressBarImage {
    protected ResourceLocation image;
    protected int backOffsetX;
    protected int backOffsetY;
    protected int foreOffsetX;
    protected int foreOffsetY;
    protected int backWidth;
    protected int backHeight;
    protected int foreWidth;
    protected int foreHeight;
    protected int insetX;
    protected int insetY;
    EnumFacing direction;

    public ProgressBarImage(int backOffsetX, int backOffsetY, int backWidth, int backHeight, int foreOffsetX, int foreOffsetY, int foreWidth, int foreHeight, int insetX, int insetY, EnumFacing direction, ResourceLocation image) {
        this.backOffsetX = backOffsetX;
        this.backOffsetY = backOffsetY;
        this.backWidth = backWidth;
        this.backHeight = backHeight;
        this.foreOffsetX = foreOffsetX;
        this.foreOffsetY = foreOffsetY;
        this.foreHeight = foreHeight;
        this.foreWidth = foreWidth;
        this.insetX = insetX;
        this.insetY = insetY;
        this.direction = direction;
        this.image = image;
    }

    public ProgressBarImage(int backOffsetX, int backOffsetY, int backWidth, int backHeight, int foreOffsetX, int foreOffsetY, int foreWidth, int foreHeight, EnumFacing direction, ResourceLocation image) {
        this(backOffsetX, backOffsetY, backWidth, backHeight, foreOffsetX, foreOffsetY, foreWidth, foreHeight, 0, 0, direction, image);
    }

    public ProgressBarImage(int backOffsetX, int backOffsetY, int backWidth, int backHeight, int foreOffsetX, int foreOffsetY, EnumFacing direction, ResourceLocation image) {
        this(backOffsetX, backOffsetY, backWidth, backHeight, foreOffsetX, foreOffsetY, backWidth, backHeight, 0, 0, direction, image);
    }

    public ResourceLocation getResourceLocation() {
        return this.image;
    }

    public int getBackOffsetX() {
        return this.backOffsetX;
    }

    public int getBackOffsetY() {
        return this.backOffsetY;
    }

    public int getForeOffsetX() {
        return this.foreOffsetX;
    }

    public int getForeOffsetY() {
        return this.foreOffsetY;
    }

    public int getBackWidth() {
        return this.backWidth;
    }

    public int getBackHeight() {
        return this.backHeight;
    }

    public int getForeWidth() {
        return this.foreWidth;
    }

    public int getForeHeight() {
        return this.foreHeight;
    }

    public int getInsetX() {
        return this.insetX;
    }

    public int getInsetY() {
        return this.insetY;
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderProgressBarPartial(int x, int y, float center, float variation, Gui gui) {
        float change;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.image);
        gui.func_73729_b(x, y, this.backOffsetX, this.backOffsetY, this.backWidth, this.backHeight);
        if (center - variation / 2.0f < 0.0f) {
            change = center - variation / 2.0f;
            center -= change / 2.0f;
            variation += change;
        }
        if (center + variation / 2.0f > 1.0f) {
            change = 1.0f - center - variation / 2.0f;
            center += change / 2.0f;
            variation -= change;
        }
        if (this.direction == EnumFacing.EAST) {
            gui.func_73729_b(x + this.insetX + (int)((float)this.foreWidth * (1.0f - center - variation / 2.0f)), y + this.insetY, this.foreOffsetX + (int)((1.0f - variation / 2.0f - center) * (float)this.foreWidth), this.foreOffsetY, (int)(variation * (float)this.foreWidth), this.foreHeight);
        } else if (this.direction == EnumFacing.UP) {
            gui.func_73729_b(x + this.insetX, y + this.insetY + this.foreHeight - (int)(variation * (float)this.foreHeight), this.foreOffsetX, this.foreOffsetY + this.foreHeight - (int)(variation * (float)this.foreHeight), this.foreWidth, (int)(variation * (float)this.foreHeight));
        } else if (this.direction == EnumFacing.DOWN) {
            gui.func_73729_b(x + this.insetX, y + this.insetY, this.foreOffsetX, this.foreOffsetY, this.foreWidth, (int)(variation * (float)this.foreHeight));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderProgressBar(int x, int y, float percent, Gui gui) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.image);
        gui.func_73729_b(x, y, this.backOffsetX, this.backOffsetY, this.backWidth, this.backHeight);
        if (this.direction == EnumFacing.EAST) {
            gui.func_73729_b(x + this.insetX, y + this.insetY, this.foreOffsetX, this.foreOffsetY, (int)(percent * (float)this.foreWidth), this.foreHeight);
        } else if (this.direction == EnumFacing.WEST) {
            gui.func_73729_b(x + this.insetX + this.foreWidth - (int)(percent * (float)this.foreWidth), y + this.insetY, this.foreOffsetX + this.foreWidth - (int)(percent * (float)this.foreWidth), this.foreOffsetY, (int)(percent * (float)this.foreWidth), this.foreHeight);
        } else if (this.direction == EnumFacing.UP) {
            gui.func_73729_b(x + this.insetX, y + this.insetY + this.foreHeight - (int)(percent * (float)this.foreHeight), this.foreOffsetX, this.foreOffsetY + this.foreHeight - (int)(percent * (float)this.foreHeight), this.foreWidth, (int)(percent * (float)this.foreHeight));
        } else if (this.direction == EnumFacing.DOWN) {
            gui.func_73729_b(x + this.insetX, y + this.insetY, this.foreOffsetX, this.foreOffsetY, this.foreWidth, (int)(percent * (float)this.foreHeight));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderProgressBar(int x, int zLevel, int y, float percent) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.image);
        this.drawTexturedModalRect(x, zLevel, y, this.backOffsetX, this.backOffsetY, this.backWidth, this.backHeight);
        if (this.direction == EnumFacing.EAST) {
            this.drawTexturedModalRect(x + this.insetX, zLevel, y + this.insetY, this.foreOffsetX, this.foreOffsetY, (int)(percent * (float)this.foreWidth), this.foreHeight);
        } else if (this.direction == EnumFacing.WEST) {
            this.drawTexturedModalRect(x + this.insetX + this.foreWidth - (int)(percent * (float)this.foreWidth), zLevel, y + this.insetY, this.foreOffsetX + this.foreWidth - (int)(percent * (float)this.foreWidth), this.foreOffsetY, (int)(percent * (float)this.foreWidth), this.foreHeight);
        } else if (this.direction == EnumFacing.UP) {
            this.drawTexturedModalRect(x + this.insetX, zLevel, y + this.insetY + this.foreHeight - (int)(percent * (float)this.foreHeight), this.foreOffsetX, this.foreOffsetY + this.foreHeight - (int)(percent * (float)this.foreHeight), this.foreWidth, (int)(percent * (float)this.foreHeight));
        } else if (this.direction == EnumFacing.DOWN) {
            this.drawTexturedModalRect(x + this.insetX, zLevel, y + this.insetY, this.foreOffsetX, this.foreOffsetY, this.foreWidth, (int)(percent * (float)this.foreHeight));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawTexturedModalRect(int x, int zLevel, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }
}

