/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.network;

import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Method;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleChannelHandlerWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.network.BasePacket;

public class PacketHandler {
    private static Class<?> defaultChannelPipeline;
    private static int discriminatorNumber;
    static Codec codec;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;
    public static PacketHandler INSTANCE;
    private static Method generateName;

    public PacketHandler() {
        try {
            defaultChannelPipeline = Class.forName("io.netty.channel.DefaultChannelPipeline");
            generateName = defaultChannelPipeline.getDeclaredMethod("generateName", ChannelHandler.class);
            generateName.setAccessible(true);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.FATAL, (Throwable)e, (String)"What? Netty isn't installed, what magic is this?", (Object[])new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
        codec = new Codec();
        channels = NetworkRegistry.INSTANCE.newChannel("libVulpes", new ChannelHandler[]{codec});
    }

    public static void init() {
        if (!channels.isEmpty()) {
            return;
        }
    }

    public final void addDiscriminator(Class clazz) {
        String type;
        FMLEmbeddedChannel channel;
        codec.addDiscriminator(discriminatorNumber, clazz);
        ++discriminatorNumber;
        if (FMLCommonHandler.instance().getSide().isClient()) {
            channel = channels.get(Side.CLIENT);
            type = channel.findChannelHandlerNameForType(Codec.class);
            this.addClientHandlerAfter(channel, type, new BasePacket.BasePacketHandlerClient(), clazz);
        }
        channel = channels.get(Side.SERVER);
        type = channel.findChannelHandlerNameForType(Codec.class);
        this.addServerHandlerAfter(channels.get(Side.SERVER), type, new BasePacket.BasePacketHandlerServer(), clazz);
    }

    private <REQ extends IMessage, REPLY extends IMessage, NH extends INetHandler> void addServerHandlerAfter(FMLEmbeddedChannel channel, String type, IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestType) {
        SimpleChannelHandlerWrapper<? super REQ, ? extends REPLY> handler = this.getHandlerWrapper(messageHandler, Side.SERVER, requestType);
        channel.pipeline().addAfter(type, this.generateName(channel.pipeline(), (ChannelHandler)handler), handler);
    }

    private <REQ extends IMessage, REPLY extends IMessage, NH extends INetHandler> void addClientHandlerAfter(FMLEmbeddedChannel channel, String type, IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestType) {
        SimpleChannelHandlerWrapper<? super REQ, ? extends REPLY> handler = this.getHandlerWrapper(messageHandler, Side.CLIENT, requestType);
        channel.pipeline().addAfter(type, this.generateName(channel.pipeline(), (ChannelHandler)handler), handler);
    }

    private <REPLY extends IMessage, REQ extends IMessage> SimpleChannelHandlerWrapper<REQ, REPLY> getHandlerWrapper(IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Side side, Class<REQ> requestType) {
        return new SimpleChannelHandlerWrapper(messageHandler, side, requestType);
    }

    private String generateName(ChannelPipeline pipeline, ChannelHandler handler) {
        try {
            return (String)generateName.invoke(defaultChannelPipeline.cast(pipeline), handler);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.FATAL, (Throwable)e, (String)"It appears we somehow have a not-standard pipeline. Huh", (Object[])new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static final void sendToServer(BasePacket packet) {
        channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channels.get(Side.CLIENT).writeAndFlush((Object)packet).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static final void sendToPlayersTrackingEntity(BasePacket packet, Entity entity) {
        for (EntityPlayer player : ((WorldServer)entity.field_70170_p).func_73039_n().getTrackingPlayers(entity)) {
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            channels.get(Side.SERVER).writeAndFlush((Object)packet).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }

    public static final void sendToAll(BasePacket packet) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channels.get(Side.SERVER).writeAndFlush((Object)packet).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static final void sendToPlayer(BasePacket packet, EntityPlayer player) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channels.get(Side.SERVER).writeAndFlush((Object)packet).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static final void sendToDispatcher(BasePacket packet, NetworkManager netman) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DISPATCHER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)NetworkDispatcher.get((NetworkManager)netman));
        channels.get(Side.SERVER).writeAndFlush((Object)packet).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static final void sendToNearby(BasePacket packet, int dimId, int x, int y, int z, double dist) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(dimId, (double)x, (double)y, (double)z, dist));
        channels.get(Side.SERVER).writeAndFlush((Object)packet).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static final void sendToNearby(BasePacket packet, int dimId, BlockPos pos, double dist) {
        PacketHandler.sendToNearby(packet, dimId, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dist);
    }

    static {
        discriminatorNumber = 0;
        codec = new Codec();
        INSTANCE = new PacketHandler();
    }

    @ChannelHandler.Sharable
    private static final class HandlerServer
    extends SimpleChannelInboundHandler<BasePacket> {
        private HandlerServer() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, BasePacket packet) throws Exception {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                return;
            }
            EntityPlayerMP player = ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
            packet.executeServer(player);
        }
    }

    @ChannelHandler.Sharable
    @SideOnly(value=Side.CLIENT)
    private static final class HandlerClient
    extends SimpleChannelInboundHandler<BasePacket> {
        private HandlerClient() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, BasePacket packet) throws Exception {
            Minecraft mc = Minecraft.func_71410_x();
            packet.executeClient((EntityPlayer)mc.field_71439_g);
        }
    }

    private static final class Codec
    extends FMLIndexedMessageToMessageCodec<BasePacket> {
        private Codec() {
        }

        public void encodeInto(ChannelHandlerContext ctx, BasePacket msg, ByteBuf data) throws Exception {
            msg.write(data);
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf data, BasePacket packet) {
            Side side = FMLCommonHandler.instance().getSide();
            if (FMLCommonHandler.instance().getSide().isClient()) {
                side = FMLCommonHandler.instance().getEffectiveSide();
            }
            switch (side) {
                case CLIENT: {
                    packet.readClient(data);
                    LibVulpes.proxy.addScheduledTask(packet);
                    break;
                }
                case SERVER: {
                    packet.read(data);
                }
            }
        }

        public class executorServer
        implements Runnable {
            final Side side;
            final BasePacket packet;
            final EntityPlayer player;

            public executorServer(BasePacket packet, EntityPlayer player, Side side) {
                this.packet = packet;
                this.player = player;
                this.side = side;
            }

            @Override
            public void run() {
                this.packet.executeServer((EntityPlayerMP)this.player);
            }
        }
    }
}

